/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.sample.converter;

import io.rocketbase.commons.converter.EntityReadWriteConverter;
import io.rocketbase.sample.converter.CentralConfig;
import io.rocketbase.sample.converter.CompanyConverter;
import io.rocketbase.sample.dto.company.CompanyRead;
import io.rocketbase.sample.dto.employee.EmployeeRead;
import io.rocketbase.sample.dto.employee.EmployeeWrite;
import io.rocketbase.sample.model.CompanyEntity;
import io.rocketbase.sample.model.EmployeeEntity;
import io.rocketbase.sample.repository.mongo.CompanyRepository;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(config=CentralConfig.class)
public abstract class EmployeeConverter
implements EntityReadWriteConverter<EmployeeEntity, EmployeeRead, EmployeeWrite> {
    @Autowired
    protected CompanyRepository companyRepository;
    @Autowired
    protected CompanyConverter companyConverter;

    @Mapping(target="company", expression="java( convertCompanyId( entity.getCompanyId() ) )")
    public abstract EmployeeRead fromEntity(EmployeeEntity var1);

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="companyId", ignore=true)})
    public abstract EmployeeEntity newEntity(EmployeeWrite var1);

    @InheritConfiguration
    public abstract EmployeeEntity updateEntityFromEdit(EmployeeWrite var1, @MappingTarget EmployeeEntity var2);

    public CompanyRead convertCompanyId(String companyId) {
        return this.companyConverter.fromEntity((CompanyEntity)this.companyRepository.findById(companyId).orElseGet(null));
    }
}

