/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.sample.converter;

import io.rocketbase.sample.converter.CustomerConverter;
import io.rocketbase.sample.converter.ObfuscatedIdMapper;
import io.rocketbase.sample.dto.customer.CustomerRead;
import io.rocketbase.sample.dto.customer.CustomerWrite;
import io.rocketbase.sample.model.CustomerEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerConverterImpl
implements CustomerConverter {
    @Autowired
    private ObfuscatedIdMapper obfuscatedIdMapper;

    @Override
    public CustomerRead fromEntity(CustomerEntity entity) {
        if (entity == null) {
            return null;
        }
        CustomerRead customerRead = new CustomerRead();
        if (entity.getId() != null) {
            customerRead.setId(this.obfuscatedIdMapper.convert(entity.getId()));
        }
        customerRead.setName(entity.getName());
        return customerRead;
    }

    @Override
    public CustomerEntity newEntity(CustomerWrite workspace) {
        if (workspace == null) {
            return null;
        }
        CustomerEntity customerEntity = new CustomerEntity();
        customerEntity.setName(workspace.getName());
        return customerEntity;
    }

    @Override
    public CustomerEntity updateEntityFromEdit(CustomerWrite write, CustomerEntity entity) {
        if (write == null) {
            return entity;
        }
        entity.setName(write.getName());
        return entity;
    }
}

