/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import io.rocketbase.commons.util.Nulls;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public final class UrlParts {
    public static String concatPaths(Object ... parts) {
        Object result = "";
        if (parts != null) {
            for (Object p : parts) {
                String str = String.valueOf(p);
                if (p == null || !StringUtils.hasText((String)str)) continue;
                if (((String)result).length() > 0 && !str.startsWith("/") && !((String)result).endsWith("/")) {
                    result = (String)result + "/";
                }
                result = (String)result + str;
            }
        }
        return result;
    }

    public static String ensureEndsWithSlash(String uri) {
        if (uri == null) {
            return "/";
        }
        if (!uri.endsWith("/")) {
            return String.format("%s/", uri);
        }
        return uri;
    }

    public static String ensureStartsWithSlash(String uri) {
        if (uri == null) {
            return "/";
        }
        if (!uri.startsWith("/")) {
            return String.format("/%s", uri);
        }
        return uri;
    }

    public static String ensureStartsAndEndsWithSlash(String path) {
        String fixedStart = UrlParts.ensureStartsWithSlash(path);
        return UrlParts.ensureEndsWithSlash(fixedStart);
    }

    public static String removeEndsWithSlash(String path) {
        String value = Nulls.notNull(path);
        if (value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public static String getBaseUrl(HttpServletRequest request) {
        Object result = request.getScheme() + "://" + request.getServerName();
        int serverPort = request.getServerPort();
        if (serverPort != 80 && serverPort != 443) {
            result = (String)result + ":" + serverPort;
        }
        if (((String)(result = (String)result + request.getContextPath())).endsWith("/")) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }
}

