/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import io.rocketbase.commons.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class StopwatchParts {
    private StopwatchPartitionedConfig config;
    private Map<String, Long> detailTimings;
    private long lastLogged;
    private String lastCaption;

    StopwatchParts(StopwatchPartitionedConfig config) {
        this.config = config;
        this.detailTimings = new LinkedHashMap<String, Long>();
        this.lastLogged = System.currentTimeMillis();
    }

    public static StopwatchParts start() {
        return new StopwatchPartitionedConfig().start();
    }

    public static StopwatchPartitionedConfig build() {
        return new StopwatchPartitionedConfig();
    }

    public void part(String caption) {
        long time = System.currentTimeMillis() - this.lastLogged;
        this.detailTimings.put(caption, this.detailTimings.getOrDefault(caption, 0L) + time);
        this.lastLogged = System.currentTimeMillis();
        this.lastCaption = caption;
    }

    public String print() {
        if (this.lastCaption != null) {
            this.part(this.lastCaption);
        }
        StringBuilder builder = new StringBuilder();
        long totalTime = this.totalMillis();
        builder.append(this.config.getPrintPrefix()).append(TimeUtil.convertMillisToMinSecFormat(totalTime));
        ArrayList<Map.Entry<String, Long>> values = PartOrdering.NATURAL.equals((Object)this.config.getPartOrdering()) ? new ArrayList<Map.Entry<String, Long>>(this.detailTimings.entrySet()) : this.detailTimings.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        int partsToPrint = (this.config.getLimitParts() >= 0 ? Math.min(this.config.getLimitParts(), values.size()) : values.size()) - 1;
        if (partsToPrint > 0) {
            builder.append(" [");
            for (int x = 0; x <= partsToPrint; ++x) {
                Map.Entry entry = (Map.Entry)values.get(x);
                this.appendPart(builder, (String)entry.getKey(), (Long)entry.getValue(), totalTime);
                if (x == partsToPrint) continue;
                builder.append(" | ");
            }
            if (this.config.isSkippedSummary() && values.size() - 1 > partsToPrint) {
                long otherTotal = 0L;
                for (int x = partsToPrint + 1; x < values.size(); ++x) {
                    otherTotal += ((Long)((Map.Entry)values.get(x)).getValue()).longValue();
                }
                builder.append(" | ");
                this.appendPart(builder, this.config.getSkippedPartName(), otherTotal, totalTime);
            }
            builder.append("]");
        }
        return builder.toString();
    }

    private void appendPart(StringBuilder builder, String part, long time, long totalTime) {
        if (this.config.isPartPercentage()) {
            builder.append((int)((double)time / (double)totalTime * 100.0)).append("% ");
        }
        builder.append(part);
        if (this.config.isPartTimings()) {
            builder.append(": ").append(TimeUtil.convertMillisToFormatted(time));
        }
    }

    public Map<String, Long> details() {
        return Collections.unmodifiableMap(this.detailTimings);
    }

    public Long totalMillis() {
        long additional = System.currentTimeMillis() - this.lastLogged;
        return this.detailTimings.values().stream().mapToLong(Long::longValue).sum() + additional;
    }

    public static class StopwatchPartitionedConfig {
        private String printPrefix = "\u23f1 ";
        private PartOrdering partOrdering = PartOrdering.TIME_DESC;
        private boolean partPercentage = true;
        private boolean partTimings = true;
        private int limitParts = -1;
        private boolean skippedSummary = true;
        private String skippedPartName = "\"other\"";

        StopwatchPartitionedConfig() {
        }

        public StopwatchPartitionedConfig withPrefix(String printPrefix) {
            this.printPrefix = printPrefix;
            return this;
        }

        public StopwatchPartitionedConfig withOrdered(PartOrdering partOrdering) {
            this.partOrdering = partOrdering;
            return this;
        }

        public StopwatchPartitionedConfig withPercentage(boolean partPercentage) {
            this.partPercentage = partPercentage;
            return this;
        }

        public StopwatchPartitionedConfig withTimings(boolean partTimings) {
            this.partTimings = partTimings;
            return this;
        }

        public StopwatchPartitionedConfig limitParts(int limitParts) {
            this.limitParts = limitParts;
            return this;
        }

        public StopwatchPartitionedConfig skippedPartName(String skippedPartName) {
            this.skippedPartName = skippedPartName;
            return this;
        }

        public StopwatchPartitionedConfig withSkippedSummary(boolean skippedSummary) {
            this.skippedSummary = skippedSummary;
            return this;
        }

        public StopwatchParts start() {
            return new StopwatchParts(this);
        }

        @Generated
        String getPrintPrefix() {
            return this.printPrefix;
        }

        @Generated
        PartOrdering getPartOrdering() {
            return this.partOrdering;
        }

        @Generated
        boolean isPartPercentage() {
            return this.partPercentage;
        }

        @Generated
        boolean isPartTimings() {
            return this.partTimings;
        }

        @Generated
        int getLimitParts() {
            return this.limitParts;
        }

        @Generated
        boolean isSkippedSummary() {
            return this.skippedSummary;
        }

        @Generated
        String getSkippedPartName() {
            return this.skippedPartName;
        }
    }

    static enum PartOrdering {
        NATURAL,
        TIME_DESC;

    }
}

