/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class QueryParamParser {
    public static List<DateTimeFormatter> DEFAULT_DATE_FORMATTERS = Arrays.asList(DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ofPattern("d/MM/yyyy"), DateTimeFormatter.ofPattern("d.MM.yyyy"));

    public static Pageable parsePageRequest(MultiValueMap<String, String> params) {
        return QueryParamParser.parsePageRequest(params, null, 25, 200);
    }

    public static Pageable parsePageRequest(MultiValueMap<String, String> params, Sort defaultSort, int defaultPageSize, int maxPageSize) {
        Integer pageSize = QueryParamParser.parseInteger(params, "pageSize", null);
        if (pageSize == null) {
            pageSize = QueryParamParser.parseInteger(params, "size", defaultPageSize);
        }
        pageSize = Math.min(pageSize, maxPageSize);
        Integer page = QueryParamParser.parseInteger(params, "page", 0);
        return PageRequest.of((int)Math.max(page, 0), (int)Math.max(pageSize, 1), (Sort)QueryParamParser.parseSort(params, "sort", defaultSort));
    }

    public static Pageable parsePageRequest(MultiValueMap<String, String> params, String pageSizeKey, String pageKey, String sortKey, Sort defaultSort, int defaultPageSize, int maxPageSize) {
        Integer pageSize = QueryParamParser.parseInteger(params, pageSizeKey, defaultPageSize);
        pageSize = Math.min(pageSize, maxPageSize);
        Integer page = QueryParamParser.parseInteger(params, pageKey, 0);
        return PageRequest.of((int)Math.max(page, 0), (int)Math.max(pageSize, 1), (Sort)QueryParamParser.parseSort(params, sortKey, defaultSort));
    }

    public static Sort parseSort(MultiValueMap<String, String> params, String key) {
        return QueryParamParser.parseSort(params, key, null);
    }

    public static Sort parseSort(MultiValueMap<String, String> params, String key, Sort defaultSort) {
        Sort sort;
        Sort sort2 = sort = defaultSort != null ? defaultSort : Sort.unsorted();
        if (params != null && params.containsKey((Object)key)) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (String s : (List)params.get((Object)key)) {
                if (s.toLowerCase().matches("[a-z0-9]+\\,(asc|desc)")) {
                    String[] splitted = s.split("\\,");
                    orders.add(new Sort.Order(Sort.Direction.fromString((String)splitted[1]), splitted[0]));
                    continue;
                }
                if (!s.toLowerCase().matches("[a-z0-9]+")) continue;
                orders.add(Sort.Order.by((String)s));
            }
            if (orders.size() > 0) {
                sort = Sort.by(orders);
            }
        }
        return sort;
    }

    public static String parseString(MultiValueMap<String, String> params, String key) {
        return params != null && params.containsKey((Object)key) ? (String)params.getFirst((Object)key) : null;
    }

    public static Integer parseInteger(MultiValueMap<String, String> params, String key, Integer defaultValue) {
        Long value = QueryParamParser.parseLong(params, key, null);
        if (value != null) {
            return value.intValue();
        }
        return defaultValue;
    }

    public static Integer parseInteger(String value, Integer defaultValue) {
        Long v = QueryParamParser.parseLong(value, null);
        if (v != null) {
            return v.intValue();
        }
        return defaultValue;
    }

    public static Long parseLong(MultiValueMap<String, String> params, String key, Long defaultValue) {
        return QueryParamParser.parseLong(QueryParamParser.parseString(params, key), defaultValue);
    }

    public static Long parseLong(String value, Long defaultValue) {
        if (value != null && value.matches("-?[0-9]+")) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Boolean parseBoolean(MultiValueMap<String, String> params, String key, Boolean defaultValue) {
        return QueryParamParser.parseBoolean(QueryParamParser.parseString(params, key), defaultValue);
    }

    public static Boolean parseBoolean(String value, Boolean defaultValue) {
        if (value != null) {
            return value.matches("(true|1|yes|on)");
        }
        return defaultValue;
    }

    public static LocalDate parseLocalDate(MultiValueMap<String, String> params, String key, LocalDate defaultValue) {
        return QueryParamParser.parseLocalDate(QueryParamParser.parseString(params, key), defaultValue);
    }

    public static LocalDate parseLocalDate(String value, LocalDate defaultValue) {
        if (value != null) {
            for (DateTimeFormatter formatter : DEFAULT_DATE_FORMATTERS) {
                try {
                    return LocalDate.parse(value, formatter);
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
        }
        return defaultValue;
    }

    public static LocalTime parseLocalTime(MultiValueMap<String, String> params, String key, LocalTime defaultValue) {
        return QueryParamParser.parseLocalTime(QueryParamParser.parseString(params, key), defaultValue);
    }

    public static LocalTime parseLocalTime(String value, LocalTime defaultValue) {
        if (value != null) {
            try {
                return LocalTime.parse(value, DateTimeFormatter.ISO_LOCAL_TIME);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static LocalDateTime parseLocalDateTime(MultiValueMap<String, String> params, String key, LocalDateTime defaultValue) {
        return QueryParamParser.parseLocalDateTime(QueryParamParser.parseString(params, key), defaultValue);
    }

    public static LocalDateTime parseLocalDateTime(String value, LocalDateTime defaultValue) {
        if (value != null) {
            try {
                return LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException ex) {
                try {
                    return Instant.parse(value).atZone(ZoneOffset.systemDefault().getRules().getOffset(LocalDateTime.now())).toLocalDateTime();
                }
                catch (DateTimeException dateTimeException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    public static Instant parseInstant(MultiValueMap<String, String> params, String key, Instant defaultValue) {
        return QueryParamParser.parseInstant(QueryParamParser.parseString(params, key), defaultValue);
    }

    public static Instant parseInstant(String value, Instant defaultValue) {
        block3: {
            if (value != null) {
                try {
                    Instant instant = Instant.parse(value);
                    return instant;
                }
                catch (DateTimeParseException ex) {
                    if (!value.matches("[0-9]+")) break block3;
                    long longValue = Long.parseLong(value);
                    int currentYear = LocalDate.now().getYear();
                    Instant instant = Instant.ofEpochSecond(longValue);
                    ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                    if (zonedDateTime.getYear() >= currentYear + 100 || zonedDateTime.getYear() <= 2001) break block3;
                    return instant;
                }
            }
        }
        return defaultValue;
    }

    public static <T extends Enum> T parseEnum(MultiValueMap<String, String> params, String key, Class<T> clazz, T defaultValue) {
        return QueryParamParser.parseEnum(QueryParamParser.parseString(params, key), clazz, defaultValue);
    }

    public static <T extends Enum> T parseEnum(String value, Class<T> clazz, T defaultValue) {
        if (value != null) {
            try {
                return Enum.valueOf(clazz, value.toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T extends Enum> Set<T> parseEnumSet(MultiValueMap<String, String> params, String key, Class<T> clazz, Set<T> defaultValue) {
        if (params.containsKey((Object)key)) {
            HashSet<T> result = new HashSet<T>();
            for (String v : (List)params.get((Object)key)) {
                Object enumValue = QueryParamParser.parseEnum(v, clazz, null);
                if (enumValue == null) continue;
                result.add(enumValue);
            }
            return result.isEmpty() ? defaultValue : result;
        }
        return defaultValue;
    }

    public static Map<String, String> parseKeyValue(String key, MultiValueMap<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (params != null && params.containsKey((Object)key)) {
            for (String kv : (List)params.get((Object)key)) {
                String[] split = StringUtils.split((String)kv, (String)";");
                if (split == null) continue;
                result.put(split[0], split[1]);
            }
        }
        return result;
    }
}

