/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import io.rocketbase.commons.util.Nulls;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.util.UriComponentsBuilder;

public final class QueryParamBuilder {
    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, String value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        uriBuilder.queryParam(key, new Object[]{value});
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, Pageable pageable) {
        return QueryParamBuilder.appendParams(uriBuilder, "pageSize", "page", "sort", pageable);
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String pageSizeKey, String pageKey, String sortKey, Pageable value) {
        if (uriBuilder == null || value == null) {
            return uriBuilder;
        }
        if (value.getPageNumber() >= 0) {
            uriBuilder.queryParam(Nulls.notEmpty(pageKey, "page"), new Object[]{value.getPageNumber()});
        }
        if (value.getPageSize() >= 0) {
            uriBuilder.queryParam(Nulls.notEmpty(pageSizeKey, "pageSize"), new Object[]{value.getPageSize()});
        }
        QueryParamBuilder.appendParams(uriBuilder, Nulls.notEmpty(sortKey, "sort"), value.getSort());
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, Sort value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        value.iterator().forEachRemaining(o -> uriBuilder.queryParam(key, new Object[]{String.format("%s,%s", o.getProperty(), o.getDirection().name().toLowerCase())}));
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, Number value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        uriBuilder.queryParam(key, new Object[]{value});
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, Boolean value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        uriBuilder.queryParam(key, new Object[]{value != false ? "true" : "false"});
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, LocalDate value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        uriBuilder.queryParam(key, new Object[]{DateTimeFormatter.ISO_LOCAL_DATE.format(value)});
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, LocalTime value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        uriBuilder.queryParam(key, new Object[]{DateTimeFormatter.ISO_LOCAL_TIME.format(value)});
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, LocalDateTime value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        uriBuilder.queryParam(key, new Object[]{DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(value)});
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, Instant value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        uriBuilder.queryParam(key, new Object[]{value.toString()});
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, Enum value) {
        if (!Nulls.noneNullValue(uriBuilder, key, value)) {
            return uriBuilder;
        }
        uriBuilder.queryParam(key, new Object[]{value.name()});
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParamEnums(UriComponentsBuilder uriBuilder, String key, Collection<? extends Enum> values) {
        if (!Nulls.noneNullValue(uriBuilder, key, values)) {
            return uriBuilder;
        }
        for (Enum enum_ : values) {
            QueryParamBuilder.appendParams(uriBuilder, key, enum_);
        }
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParamNumbers(UriComponentsBuilder uriBuilder, String key, Collection<? extends Number> values) {
        if (!Nulls.noneNullValue(uriBuilder, key, values)) {
            return uriBuilder;
        }
        for (Number number : values) {
            QueryParamBuilder.appendParams(uriBuilder, key, number);
        }
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParamStrings(UriComponentsBuilder uriBuilder, String key, Collection<? extends String> values) {
        if (!Nulls.noneNullValue(uriBuilder, key, values)) {
            return uriBuilder;
        }
        for (String string : values) {
            QueryParamBuilder.appendParams(uriBuilder, key, string);
        }
        return uriBuilder;
    }

    public static UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, String key, Map<String, String> keyValues) {
        if (uriBuilder != null && key != null && keyValues != null && !keyValues.isEmpty()) {
            for (Map.Entry<String, String> entry : keyValues.entrySet()) {
                uriBuilder.queryParam(key, new Object[]{String.format("%s;%s", entry.getKey(), entry.getValue())});
            }
        }
        return uriBuilder;
    }
}

