/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.translation;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.rocketbase.commons.translation.Translated;
import io.rocketbase.commons.translation.Translation;
import io.rocketbase.commons.util.Nulls;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;

public class TranslationSerializer
extends JsonSerializer<Translation>
implements ContextualSerializer {
    protected final TranslationSerializerConfig config;

    public TranslationSerializer() {
        this(new TranslationSerializerConfig(false));
    }

    public void serialize(Translation value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        if (this.config.isTranslated()) {
            this.writeTranslated(value, jsonGenerator);
        } else {
            this.writeObject(value, jsonGenerator);
        }
    }

    protected void writeTranslated(Translation value, JsonGenerator jsonGenerator) throws IOException {
        String valueTranslated = value.getTranslated(Nulls.notNull(this.config.getLocale(), LocaleContextHolder.getLocale()));
        if (valueTranslated != null) {
            jsonGenerator.writeString(valueTranslated);
        } else {
            jsonGenerator.writeNull();
        }
    }

    protected void writeObject(Translation value, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<Locale, String> entry : value.getTranslations().entrySet()) {
            jsonGenerator.writeStringField(entry.getKey().toLanguageTag(), entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    public void serializeWithType(Translation value, JsonGenerator jsonGenerator, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, jsonGenerator, serializers);
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        try {
            Translated annotation = (Translated)beanProperty.getAnnotation(Translated.class);
            if (annotation != null) {
                TranslationSerializerConfig config = new TranslationSerializerConfig(true);
                if (StringUtils.hasText((String)annotation.value())) {
                    config.setLocale(Locale.forLanguageTag(annotation.value()));
                }
                return new TranslationSerializer(config);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TranslationSerializer();
    }

    @Generated
    public TranslationSerializer(TranslationSerializerConfig config) {
        this.config = config;
    }

    protected static class TranslationSerializerConfig {
        private boolean translated;
        private Locale locale;

        public TranslationSerializerConfig(boolean translated) {
            this.translated = translated;
        }

        @Generated
        public boolean isTranslated() {
            return this.translated;
        }

        @Generated
        public Locale getLocale() {
            return this.locale;
        }

        @Generated
        public void setTranslated(boolean translated) {
            this.translated = translated;
        }

        @Generated
        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TranslationSerializerConfig)) {
                return false;
            }
            TranslationSerializerConfig other = (TranslationSerializerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isTranslated() != other.isTranslated()) {
                return false;
            }
            Locale this$locale = this.getLocale();
            Locale other$locale = other.getLocale();
            return !(this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TranslationSerializerConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isTranslated() ? 79 : 97);
            Locale $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TranslationSerializer.TranslationSerializerConfig(translated=" + this.isTranslated() + ", locale=" + this.getLocale() + ")";
        }
    }
}

