/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.translation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.rocketbase.commons.translation.Translation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class TranslationDeserializer
extends JsonDeserializer<Translation> {
    public Translation deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        HashMap<Locale, String> translations = new HashMap<Locale, String>();
        String language = null;
        JsonToken currentToken = jsonParser.getCurrentToken();
        if (currentToken.equals((Object)JsonToken.VALUE_STRING)) {
            return Translation.translation(jsonParser.getText());
        }
        while (currentToken != JsonToken.END_OBJECT) {
            currentToken = jsonParser.nextToken();
            if (currentToken == JsonToken.FIELD_NAME) {
                language = jsonParser.getText();
                continue;
            }
            if (currentToken != JsonToken.VALUE_STRING) continue;
            translations.put(this.parseLanguageTag(language), jsonParser.getText());
        }
        return Translation.builder().translations(translations).build();
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }

    protected Locale parseLanguageTag(String language) {
        if (language == null) {
            return null;
        }
        return Locale.forLanguageTag(language.replace("_", "-"));
    }
}

