/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.translation;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.rocketbase.commons.translation.HasDefaultLocale;
import io.rocketbase.commons.translation.TranslationDeserializer;
import io.rocketbase.commons.translation.TranslationSerializer;
import io.rocketbase.commons.util.LocaleFilter;
import io.rocketbase.commons.util.Nulls;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.Nullable;

@JsonSerialize(using=TranslationSerializer.class)
@JsonDeserialize(using=TranslationDeserializer.class)
@Schema(description="holds translations in multiple languages")
public class Translation
implements Serializable {
    @HasDefaultLocale
    private Map<Locale, String> translations = new HashMap<Locale, String>();

    public static Translation of(Locale locale, String value) {
        return new Translation().add(locale, value);
    }

    public static Translation translation(String translation) {
        return Translation.builder().translation(LocaleContextHolder.getLocale(), translation).build();
    }

    public static TranslationBuilder builder() {
        return new TranslationBuilder();
    }

    public Translation add(Locale locale, String value) {
        this.translations.put(locale, value);
        return this;
    }

    public Translation english(String value) {
        return this.add(Locale.ENGLISH, value);
    }

    public Translation french(String value) {
        return this.add(Locale.FRENCH, value);
    }

    public Translation german(String value) {
        return this.add(Locale.GERMAN, value);
    }

    public Translation italian(String value) {
        return this.add(Locale.ITALIAN, value);
    }

    public Translation japanese(String value) {
        return this.add(Locale.JAPANESE, value);
    }

    public Translation korean(String value) {
        return this.add(Locale.KOREAN, value);
    }

    public Translation chinese(String value) {
        return this.add(Locale.CHINESE, value);
    }

    public Translation root(String value) {
        return this.add(Locale.ROOT, value);
    }

    public Set<Locale> getLocales() {
        return this.translations.keySet();
    }

    @Nullable
    public String getTranslated(Locale locale) {
        Map.Entry<Locale, String> foundEntry = LocaleFilter.findClosest(locale, this.translations, Locale.ENGLISH);
        if (foundEntry != null) {
            return foundEntry.getValue();
        }
        if (this.translations.containsKey(LocaleContextHolder.getLocale())) {
            foundEntry = LocaleFilter.findClosest(LocaleContextHolder.getLocale(), this.translations);
            return foundEntry != null ? foundEntry.getValue() : null;
        }
        if (this.getLocales().contains(Locale.ROOT) && Locale.ROOT.equals(locale)) {
            return this.getTranslated(Locale.ROOT);
        }
        if (this.translations.size() == 1) {
            return this.translations.values().iterator().next();
        }
        return null;
    }

    @Nullable
    public String getTranslated() {
        return this.getTranslated(LocaleContextHolder.getLocale());
    }

    public boolean hasLocale(Locale locale) {
        return this.translations.containsKey(locale);
    }

    public boolean hasLocaleLooselyFilter(Locale locale) {
        return LocaleFilter.findClosest(locale, this.translations) != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Translation)) {
            return false;
        }
        Translation other = (Translation)o;
        Map<Locale, String> oTrans = Nulls.notNull(this.getTranslations());
        Map<Locale, String> otherTrans = Nulls.notNull(other.getTranslations());
        if (oTrans.isEmpty() && otherTrans.isEmpty()) {
            return true;
        }
        if (!oTrans.keySet().equals(otherTrans.keySet())) {
            return false;
        }
        for (Map.Entry<Locale, String> entry : oTrans.entrySet()) {
            if (entry.getValue().equals(oTrans.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Nulls.notNull(this.getTranslations()).hashCode();
        return result;
    }

    public String toString() {
        return "Translation(" + this.getTranslations() + ")";
    }

    @Generated
    public Translation() {
    }

    @Generated
    public Translation(Map<Locale, String> translations) {
        this.translations = translations;
    }

    @Generated
    public Map<Locale, String> getTranslations() {
        return this.translations;
    }

    @Generated
    public void setTranslations(Map<Locale, String> translations) {
        this.translations = translations;
    }

    public static class TranslationBuilder {
        private Map<Locale, String> translations;

        TranslationBuilder() {
        }

        public TranslationBuilder translations(Map<Locale, String> translations) {
            this.translations = translations;
            return this;
        }

        public TranslationBuilder translation(Locale locale, String translation) {
            if (this.translations == null) {
                this.translations = new HashMap<Locale, String>();
            }
            this.translations.put(locale, translation);
            return this;
        }

        public Translation build() {
            return new Translation(this.translations);
        }
    }
}

