/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.translation;

import io.rocketbase.commons.translation.HasDefaultLocale;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public class HasDefaultLocaleValidator
implements ConstraintValidator<HasDefaultLocale, Map<Locale, String>> {
    public void initialize(HasDefaultLocale constraintAnnotation) {
    }

    public boolean isValid(Map<Locale, String> value, ConstraintValidatorContext context) {
        if (value != null) {
            HashSet<Locale> locales = new HashSet<Locale>(Arrays.asList(LocaleContextHolder.getLocale(), Locale.ENGLISH));
            for (Locale locale : locales) {
                if (!value.containsKey(locale) || value.get(locale) == null || value.get(locale).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

