/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.resource;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.rocketbase.commons.dto.ErrorResponse;
import io.rocketbase.commons.exception.BadRequestException;
import io.rocketbase.commons.exception.NotFoundException;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class BasicResponseErrorHandler
extends DefaultResponseErrorHandler {
    private ObjectMapper objectMapper;

    protected ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper().findAndRegisterModules();
            this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
        return this.objectMapper;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        if (response.getStatusCode().equals(HttpStatus.BAD_REQUEST)) {
            ErrorResponse errorResponse = null;
            try {
                errorResponse = (ErrorResponse)this.getObjectMapper().readValue(response.getBody(), ErrorResponse.class);
            }
            catch (Exception e) {
                errorResponse = new ErrorResponse(HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase());
            }
            throw new BadRequestException(errorResponse);
        }
        if (response.getStatusCode().equals(HttpStatus.NOT_FOUND)) {
            throw new NotFoundException();
        }
        super.handleError(response);
    }
}

