/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Map;
import org.springframework.lang.Nullable;

@Schema(description="entity/dto has key value capability")
public interface HasKeyValue {
    @Nullable
    @Schema(description="the internal map - changes should only be done by add/remove KeyValue")
    public Map<String, String> getKeyValues();

    public void setKeyValues(Map<String, String> var1);

    default public boolean hasKeyValue(String key) {
        return this.getKeyValues() != null && key != null && this.getKeyValues().containsKey(key);
    }

    default public String getKeyValue(String key) {
        return this.getKeyValues() != null && key != null ? (String)this.getKeyValues().getOrDefault(key, null) : null;
    }

    default public <T> T getKeyValue(String key, TypeReference<T> reference, T fallback) {
        String value = this.getKeyValue(key);
        if (value == null) {
            return fallback;
        }
        try {
            return (T)new ObjectMapper().findAndRegisterModules().readValue(value, reference);
        }
        catch (JsonProcessingException e) {
            return fallback;
        }
    }

    default public Boolean getKeyValueBoolean(String key, Boolean fallback) {
        return this.getKeyValue(key, new TypeReference<Boolean>(){}, fallback);
    }

    default public Long getKeyValueLong(String key, Long fallback) {
        return this.getKeyValue(key, new TypeReference<Long>(){}, fallback);
    }

    default public Collection<String> getKeyValueCollection(String key, Collection<String> fallback) {
        return this.getKeyValue(key, new TypeReference<Collection<String>>(){}, fallback);
    }
}

