/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.Transient;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public interface HasFirstAndLastName {
    @Nullable
    public String getFirstName();

    @Nullable
    public String getLastName();

    @Transient
    @Nullable
    @Schema(example="combines first + last name")
    default public String getFullName() {
        boolean emptyLastName;
        boolean emptyFirstName = !StringUtils.hasText((String)this.getFirstName());
        boolean bl = emptyLastName = !StringUtils.hasText((String)this.getLastName());
        if (emptyFirstName && emptyLastName) {
            return null;
        }
        if (!emptyFirstName && !emptyLastName) {
            return String.format("%s %s", this.getFirstName(), this.getLastName());
        }
        if (!emptyFirstName) {
            return this.getFirstName();
        }
        return this.getLastName();
    }
}

