/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.rocketbase.commons.model.HasKeyValue;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.springframework.util.Assert;

public interface EntityWithKeyValue<T>
extends HasKeyValue {
    default public T addKeyValue(String key, String value) {
        this.checkKeyValue(key, value);
        if (this.getKeyValues() == null) {
            this.setKeyValues(new LinkedHashMap<String, String>());
        }
        this.getKeyValues().put(key, value);
        return (T)this;
    }

    default public T addKeyValue(String key, Number value) {
        return this.addKeyValue(key, String.valueOf(value));
    }

    default public T addKeyValue(String key, Boolean value) {
        return this.addKeyValue(key, String.valueOf(value));
    }

    default public T addKeyValue(String key, Collection values) {
        return this.addKeyValue(key, new ObjectMapper().findAndRegisterModules().writeValueAsString((Object)values));
    }

    default public void removeKeyValue(String key) {
        if (this.getKeyValues() == null) {
            return;
        }
        this.getKeyValues().remove(key);
    }

    default public void checkKeyValue(String key, String value) {
        Assert.hasText((String)key, (String)"Key must not be empty");
        Assert.state((key.length() <= 50 ? 1 : 0) != 0, (String)"Key is too long - at least 50 chars");
        Assert.state((boolean)key.matches("[a-zA-Z0-9_\\-\\.\\#\\[\\]]+"), (String)"Allowed key chars are a-Z, 0-9 and _-.#[]");
        if (value != null) {
            Assert.state((value.length() <= 255 ? 1 : 0) != 0, (String)"Value is too long - at least 255 chars");
        }
    }

    default public void validateKeyValues() {
        if (this.getKeyValues() == null) {
            return;
        }
        this.getKeyValues().forEach(this::checkKeyValue);
    }
}

