/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.dto.validation;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.lang.Nullable;

@Schema(example="{\"lastName\": [{\n    \"type\": \"NotBlank\",\n    \"message\": \"may not be empty\"\n}],\n\"email\": [{\n    \"type\": \"NotNull\",\n    \"message\": \"may not be null\"\n }, {\n    \"type\": \"Email\",\n    \"message\": \"not a well-formed email address\",\n    \"flags\": [],\n    \"regexp\": \".*\"\n}]}")
public class ValidationConstraint {
    @Schema(description="Constraint type", example="NotNull")
    private String type;
    @Schema(description="Associated constraint message", example="may not be null")
    private String message;
    @Nullable
    @Schema(description="Optional constraints attributes")
    private Map<String, Object> attributes;

    @JsonAnyGetter
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonAnySetter
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Object addAttribute(String attrKey, Object attribute) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes.put(attrKey, attribute);
    }

    @Generated
    public static ValidationConstraintBuilder builder() {
        return new ValidationConstraintBuilder();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public String toString() {
        return "ValidationConstraint(type=" + this.getType() + ", message=" + this.getMessage() + ", attributes=" + this.getAttributes() + ")";
    }

    @Generated
    public ValidationConstraint(String type, String message, @Nullable Map<String, Object> attributes) {
        this.type = type;
        this.message = message;
        this.attributes = attributes;
    }

    @Generated
    public ValidationConstraint() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationConstraint)) {
            return false;
        }
        ValidationConstraint other = (ValidationConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidationConstraint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public static class ValidationConstraintBuilder {
        @Generated
        private String type;
        @Generated
        private String message;
        @Generated
        private Map<String, Object> attributes;

        @Generated
        ValidationConstraintBuilder() {
        }

        @Generated
        public ValidationConstraintBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public ValidationConstraintBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public ValidationConstraintBuilder attributes(@Nullable Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public ValidationConstraint build() {
            return new ValidationConstraint(this.type, this.message, this.attributes);
        }

        @Generated
        public String toString() {
            return "ValidationConstraint.ValidationConstraintBuilder(type=" + this.type + ", message=" + this.message + ", attributes=" + this.attributes + ")";
        }
    }
}

