/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.dto.validation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.rocketbase.commons.dto.validation.ValidationConstraint;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonPropertyOrder(value={"model", "constraints"})
@Schema(example="{\n  \"model\": \"io.rocketbase.commons.model.User\",\n     \"constraints\": {\n         \"lastName\": [{\n             \"type\": \"NotBlank\",\n             \"message\": \"may not be empty\"\n         }],\n         \"email\": [{\n             \"type\": \"NotNull\",\n             \"message\": \"may not be null\"\n          }, {\n             \"type\": \"Email\",\n             \"message\": \"not a well-formed email address\",\n             \"flags\": [],\n             \"regexp\": \".*\"\n         }],\n         \"login\": [{\n             \"type\": \"NotNull\",\n             \"message\": \"may not be null\"\n         }, {\n             \"type\": \"Length\",\n             \"message\": \"length must be between 8 and 2147483647\",\n             \"min\": 8,\n             \"max\": 2147483647\n         }],\n         \"firstName\": [{\n             \"type\": \"NotBlank\",\n             \"message\": \"may not be empty\"\n         }]\n     }\n}")
public class ModelConstraint {
    @Schema(description="Model class name", example="io.rocketbase.commons.model.User")
    private String model;
    @Schema(description="Map of all validation constraints on each model property")
    private Map<String, List<ValidationConstraint>> constraints;

    @JsonCreator
    public ModelConstraint(@JsonProperty(value="model") String modelRef) {
        this.model = modelRef;
        this.constraints = new HashMap<String, List<ValidationConstraint>>();
    }

    public List<ValidationConstraint> addConstraint(String property, ValidationConstraint constraint) {
        List<ValidationConstraint> propertyConstraints;
        if (null == this.constraints) {
            this.constraints = new HashMap<String, List<ValidationConstraint>>();
        }
        if (null == (propertyConstraints = this.constraints.get(property))) {
            propertyConstraints = new ArrayList<ValidationConstraint>();
        }
        propertyConstraints.add(constraint);
        return this.constraints.put(property, propertyConstraints);
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public Map<String, List<ValidationConstraint>> getConstraints() {
        return this.constraints;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setConstraints(Map<String, List<ValidationConstraint>> constraints) {
        this.constraints = constraints;
    }

    @Generated
    public String toString() {
        return "ModelConstraint(model=" + this.getModel() + ", constraints=" + this.getConstraints() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelConstraint)) {
            return false;
        }
        ModelConstraint other = (ModelConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModelConstraint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }
}

