/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.dto.address;

import io.rocketbase.commons.dto.address.Gender;
import io.rocketbase.commons.model.HasFirstAndLastName;
import io.rocketbase.commons.util.Nulls;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import lombok.Generated;
import org.springframework.data.annotation.Transient;
import org.springframework.lang.Nullable;

public class ContactDto
implements Serializable,
HasFirstAndLastName {
    @Nullable
    private Gender gender;
    @Size(max=10)
    @Nullable
    private @Size(max=10) String salutation;
    @Size(max=10)
    @Nullable
    private @Size(max=10) String title;
    @Size(max=100)
    @Nullable
    private @Size(max=100) String firstName;
    @Size(max=100)
    @Nullable
    private @Size(max=100) String lastName;
    @Size(max=255)
    @Email
    @Nullable
    private @Size(max=255) @Email String email;
    @Size(max=50)
    @Nullable
    private @Size(max=50) String landline;
    @Size(max=50)
    @Nullable
    private @Size(max=50) String cellphone;

    @Transient
    public String getDisplayName() {
        return Nulls.notEmpty(this.getFullName(), this.email);
    }

    @Generated
    public static ContactDtoBuilder builder() {
        return new ContactDtoBuilder();
    }

    @Nullable
    @Generated
    public Gender getGender() {
        return this.gender;
    }

    @Nullable
    @Generated
    public String getSalutation() {
        return this.salutation;
    }

    @Nullable
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    @Nullable
    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Nullable
    @Generated
    public String getEmail() {
        return this.email;
    }

    @Nullable
    @Generated
    public String getLandline() {
        return this.landline;
    }

    @Nullable
    @Generated
    public String getCellphone() {
        return this.cellphone;
    }

    @Generated
    public void setGender(@Nullable Gender gender) {
        this.gender = gender;
    }

    @Generated
    public void setSalutation(@Nullable String salutation) {
        this.salutation = salutation;
    }

    @Generated
    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Generated
    public void setFirstName(@Nullable String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(@Nullable String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    @Generated
    public void setLandline(@Nullable String landline) {
        this.landline = landline;
    }

    @Generated
    public void setCellphone(@Nullable String cellphone) {
        this.cellphone = cellphone;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContactDto)) {
            return false;
        }
        ContactDto other = (ContactDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Gender this$gender = this.getGender();
        Gender other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)((Object)this$gender)).equals((Object)other$gender)) {
            return false;
        }
        String this$salutation = this.getSalutation();
        String other$salutation = other.getSalutation();
        if (this$salutation == null ? other$salutation != null : !this$salutation.equals(other$salutation)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$landline = this.getLandline();
        String other$landline = other.getLandline();
        if (this$landline == null ? other$landline != null : !this$landline.equals(other$landline)) {
            return false;
        }
        String this$cellphone = this.getCellphone();
        String other$cellphone = other.getCellphone();
        return !(this$cellphone == null ? other$cellphone != null : !this$cellphone.equals(other$cellphone));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContactDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Gender $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)((Object)$gender)).hashCode());
        String $salutation = this.getSalutation();
        result = result * 59 + ($salutation == null ? 43 : $salutation.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $landline = this.getLandline();
        result = result * 59 + ($landline == null ? 43 : $landline.hashCode());
        String $cellphone = this.getCellphone();
        result = result * 59 + ($cellphone == null ? 43 : $cellphone.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContactDto(gender=" + this.getGender() + ", salutation=" + this.getSalutation() + ", title=" + this.getTitle() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", landline=" + this.getLandline() + ", cellphone=" + this.getCellphone() + ")";
    }

    @Generated
    public ContactDto() {
    }

    @Generated
    public ContactDto(@Nullable Gender gender, @Nullable String salutation, @Nullable String title, @Nullable String firstName, @Nullable String lastName, @Nullable String email, @Nullable String landline, @Nullable String cellphone) {
        this.gender = gender;
        this.salutation = salutation;
        this.title = title;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.landline = landline;
        this.cellphone = cellphone;
    }

    @Generated
    public static class ContactDtoBuilder {
        @Generated
        private Gender gender;
        @Generated
        private String salutation;
        @Generated
        private String title;
        @Generated
        private String firstName;
        @Generated
        private String lastName;
        @Generated
        private String email;
        @Generated
        private String landline;
        @Generated
        private String cellphone;

        @Generated
        ContactDtoBuilder() {
        }

        @Generated
        public ContactDtoBuilder gender(@Nullable Gender gender) {
            this.gender = gender;
            return this;
        }

        @Generated
        public ContactDtoBuilder salutation(@Nullable String salutation) {
            this.salutation = salutation;
            return this;
        }

        @Generated
        public ContactDtoBuilder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @Generated
        public ContactDtoBuilder firstName(@Nullable String firstName) {
            this.firstName = firstName;
            return this;
        }

        @Generated
        public ContactDtoBuilder lastName(@Nullable String lastName) {
            this.lastName = lastName;
            return this;
        }

        @Generated
        public ContactDtoBuilder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        @Generated
        public ContactDtoBuilder landline(@Nullable String landline) {
            this.landline = landline;
            return this;
        }

        @Generated
        public ContactDtoBuilder cellphone(@Nullable String cellphone) {
            this.cellphone = cellphone;
            return this;
        }

        @Generated
        public ContactDto build() {
            return new ContactDto(this.gender, this.salutation, this.title, this.firstName, this.lastName, this.email, this.landline, this.cellphone);
        }

        @Generated
        public String toString() {
            return "ContactDto.ContactDtoBuilder(gender=" + this.gender + ", salutation=" + this.salutation + ", title=" + this.title + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", landline=" + this.landline + ", cellphone=" + this.cellphone + ")";
        }
    }
}

