/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.dto.address;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import lombok.Generated;
import org.springframework.lang.Nullable;

@Schema(description="simple address object")
public class AddressDto
implements Serializable {
    @Size(max=40)
    @Nullable
    @Schema(description="first address line", example="Katharinenstra\u00dfe 30a")
    private @Size(max=40) String addressLineOne;
    @Size(max=40)
    @Nullable
    @Schema(description="second address line (optional)", example="rocketbase.io software productions GmbH")
    private @Size(max=40) String addressLineTwo;
    @Size(max=50)
    @Nullable
    @Schema(example="Hamburg")
    private @Size(max=50) String city;
    @Size(max=50)
    @Nullable
    @Schema(example="Hamburg")
    private @Size(max=50) String state;
    @Size(max=10)
    @Nullable
    @Schema(example="20457")
    private @Size(max=10) String postalCode;
    @Size(max=2)
    @Nullable
    @Schema(description="iso country code 2 letters - ISO 3166-1 alpha-2", example="de")
    private @Size(max=2) String countryCode;

    @Generated
    public static AddressDtoBuilder builder() {
        return new AddressDtoBuilder();
    }

    @Nullable
    @Generated
    public String getAddressLineOne() {
        return this.addressLineOne;
    }

    @Nullable
    @Generated
    public String getAddressLineTwo() {
        return this.addressLineTwo;
    }

    @Nullable
    @Generated
    public String getCity() {
        return this.city;
    }

    @Nullable
    @Generated
    public String getState() {
        return this.state;
    }

    @Nullable
    @Generated
    public String getPostalCode() {
        return this.postalCode;
    }

    @Nullable
    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public void setAddressLineOne(@Nullable String addressLineOne) {
        this.addressLineOne = addressLineOne;
    }

    @Generated
    public void setAddressLineTwo(@Nullable String addressLineTwo) {
        this.addressLineTwo = addressLineTwo;
    }

    @Generated
    public void setCity(@Nullable String city) {
        this.city = city;
    }

    @Generated
    public void setState(@Nullable String state) {
        this.state = state;
    }

    @Generated
    public void setPostalCode(@Nullable String postalCode) {
        this.postalCode = postalCode;
    }

    @Generated
    public void setCountryCode(@Nullable String countryCode) {
        this.countryCode = countryCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressDto)) {
            return false;
        }
        AddressDto other = (AddressDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$addressLineOne = this.getAddressLineOne();
        String other$addressLineOne = other.getAddressLineOne();
        if (this$addressLineOne == null ? other$addressLineOne != null : !this$addressLineOne.equals(other$addressLineOne)) {
            return false;
        }
        String this$addressLineTwo = this.getAddressLineTwo();
        String other$addressLineTwo = other.getAddressLineTwo();
        if (this$addressLineTwo == null ? other$addressLineTwo != null : !this$addressLineTwo.equals(other$addressLineTwo)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$postalCode = this.getPostalCode();
        String other$postalCode = other.getPostalCode();
        if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        return !(this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddressDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $addressLineOne = this.getAddressLineOne();
        result = result * 59 + ($addressLineOne == null ? 43 : $addressLineOne.hashCode());
        String $addressLineTwo = this.getAddressLineTwo();
        result = result * 59 + ($addressLineTwo == null ? 43 : $addressLineTwo.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $postalCode = this.getPostalCode();
        result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AddressDto(addressLineOne=" + this.getAddressLineOne() + ", addressLineTwo=" + this.getAddressLineTwo() + ", city=" + this.getCity() + ", state=" + this.getState() + ", postalCode=" + this.getPostalCode() + ", countryCode=" + this.getCountryCode() + ")";
    }

    @Generated
    public AddressDto() {
    }

    @Generated
    public AddressDto(@Nullable String addressLineOne, @Nullable String addressLineTwo, @Nullable String city, @Nullable String state, @Nullable String postalCode, @Nullable String countryCode) {
        this.addressLineOne = addressLineOne;
        this.addressLineTwo = addressLineTwo;
        this.city = city;
        this.state = state;
        this.postalCode = postalCode;
        this.countryCode = countryCode;
    }

    @Generated
    public static class AddressDtoBuilder {
        @Generated
        private String addressLineOne;
        @Generated
        private String addressLineTwo;
        @Generated
        private String city;
        @Generated
        private String state;
        @Generated
        private String postalCode;
        @Generated
        private String countryCode;

        @Generated
        AddressDtoBuilder() {
        }

        @Generated
        public AddressDtoBuilder addressLineOne(@Nullable String addressLineOne) {
            this.addressLineOne = addressLineOne;
            return this;
        }

        @Generated
        public AddressDtoBuilder addressLineTwo(@Nullable String addressLineTwo) {
            this.addressLineTwo = addressLineTwo;
            return this;
        }

        @Generated
        public AddressDtoBuilder city(@Nullable String city) {
            this.city = city;
            return this;
        }

        @Generated
        public AddressDtoBuilder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @Generated
        public AddressDtoBuilder postalCode(@Nullable String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        @Generated
        public AddressDtoBuilder countryCode(@Nullable String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Generated
        public AddressDto build() {
            return new AddressDto(this.addressLineOne, this.addressLineTwo, this.city, this.state, this.postalCode, this.countryCode);
        }

        @Generated
        public String toString() {
            return "AddressDto.AddressDtoBuilder(addressLineOne=" + this.addressLineOne + ", addressLineTwo=" + this.addressLineTwo + ", city=" + this.city + ", state=" + this.state + ", postalCode=" + this.postalCode + ", countryCode=" + this.countryCode + ")";
        }
    }
}

