/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

@Schema(description="wrapping object for paged result lists")
public class PageableResult<E>
implements Iterable<E>,
Serializable {
    @Schema(description="total count of values in database")
    private long totalElements;
    @Schema(description="count of pages in total with given pageSize")
    private int totalPages;
    @Schema(description="current page (starts by 0)")
    private int page;
    @Schema(description="maximum size of content list")
    private int pageSize;
    @Schema(description="content of current page. count of elements is less or equals pageSize (depends on totalElements and page/pageSize)")
    private List<E> content;

    public static <T, E> PageableResult<E> contentPage(List<E> content, Page<T> page) {
        Assert.notNull(page, (String)"page is null - not allowed");
        PageableResult<E> result = new PageableResult<E>();
        result.setContent(content != null ? content : Collections.emptyList());
        result.setTotalPages(page.getTotalPages());
        result.setTotalElements(page.getTotalElements());
        result.setPage(page.getNumber());
        result.setPageSize(page.getSize());
        return result;
    }

    public static <T, E> PageableResult<E> page(Page<T> page, Function<T, E> converter) {
        Assert.notNull(page, (String)"page is null - not allowed");
        Assert.notNull(converter, (String)"converter not defined");
        PageableResult result = new PageableResult();
        result.setContent(page.getContent().stream().map(converter).collect(Collectors.toList()));
        result.setTotalPages(page.getTotalPages());
        result.setTotalElements(page.getTotalElements());
        result.setPage(page.getNumber());
        result.setPageSize(page.getSize());
        return result;
    }

    public static <E> PageableResult<E> page(Page<E> page) {
        Assert.notNull(page, (String)"page is null - not allowed");
        PageableResult<E> result = new PageableResult<E>();
        result.setContent(page.getContent());
        result.setTotalPages(page.getTotalPages());
        result.setTotalElements(page.getTotalElements());
        result.setPage(page.getNumber());
        result.setPageSize(page.getSize());
        return result;
    }

    public static <E> PageableResult<E> content(List<E> content) {
        Assert.notNull(content, (String)"content is null - not allowed");
        PageableResult<E> result = new PageableResult<E>();
        result.setContent(content);
        result.setTotalPages(1);
        int totalElements = content.size();
        result.setTotalElements(totalElements);
        result.setPage(0);
        result.setPageSize(totalElements);
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return this.content.iterator();
    }

    @JsonIgnore
    public boolean hasNextPage() {
        return this.page < this.totalPages - 1;
    }

    @JsonIgnore
    public boolean hasPreviousPage() {
        return this.page > 0;
    }

    @JsonIgnore
    public Page<E> toPage() {
        return new PageImpl(this.getContent(), (Pageable)PageRequest.of((int)this.page, (int)this.pageSize), this.totalElements);
    }

    public <U> PageableResult<U> map(Function<? super E, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null!");
        PageableResult result = new PageableResult();
        result.setContent(this.getContent().stream().map(converter::apply).collect(Collectors.toList()));
        result.setTotalPages(this.getTotalPages());
        result.setTotalElements(this.getTotalElements());
        result.setPage(this.getPage());
        result.setPageSize(this.getPageSize());
        return result;
    }

    @Generated
    public PageableResult() {
    }

    @Generated
    public long getTotalElements() {
        return this.totalElements;
    }

    @Generated
    public int getTotalPages() {
        return this.totalPages;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    @Generated
    public List<E> getContent() {
        return this.content;
    }

    @Generated
    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    @Generated
    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    @Generated
    public void setPage(int page) {
        this.page = page;
    }

    @Generated
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setContent(List<E> content) {
        this.content = content;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageableResult)) {
            return false;
        }
        PageableResult other = (PageableResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalElements() != other.getTotalElements()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        List<E> this$content = this.getContent();
        List<E> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageableResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalElements = this.getTotalElements();
        result = result * 59 + (int)($totalElements >>> 32 ^ $totalElements);
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getPage();
        result = result * 59 + this.getPageSize();
        List<E> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageableResult(totalElements=" + this.getTotalElements() + ", totalPages=" + this.getTotalPages() + ", page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", content=" + this.getContent() + ")";
    }
}

