/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.lang.Nullable;

@Schema(description="wrapped response in case of errors")
public class ErrorResponse {
    @Schema(description="http status code", example="400")
    private Integer status;
    @Schema(description="user readable error explanation", example="bean validation exception")
    private String message;
    @Nullable
    @Schema(description="in case of form validations details related to properties. key is the filed value list of related errors", example="[\"status\": [\"not empty\"]]")
    private Map<String, List<String>> fields;

    public ErrorResponse() {
    }

    public ErrorResponse(String errorMessage) {
        this.message = errorMessage;
    }

    public ErrorResponse(Integer status, String message) {
        this.status = status;
        this.message = message;
    }

    public ErrorResponse addField(String path, String message) {
        if (this.fields == null) {
            this.fields = new HashMap<String, List<String>>();
        }
        if (!this.fields.containsKey(path)) {
            this.fields.put(path, new ArrayList());
        }
        this.fields.get(path).add(message);
        return this;
    }

    public boolean hasField(String path) {
        return this.fields != null && this.fields.containsKey(path);
    }

    public String getFirstFieldValue(String path) {
        return this.hasField(path) && !this.fields.get(path).isEmpty() ? this.fields.get(path).get(0) : null;
    }

    public List<String> getFieldValue(String path) {
        return this.hasField(path) ? this.fields.get(path) : null;
    }

    @Generated
    public static ErrorResponseBuilder builder() {
        return new ErrorResponseBuilder();
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @Generated
    public Map<String, List<String>> getFields() {
        return this.fields;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setFields(@Nullable Map<String, List<String>> fields) {
        this.fields = fields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorResponse)) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Map<String, List<String>> this$fields = this.getFields();
        Map<String, List<String>> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErrorResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Map<String, List<String>> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ErrorResponse(status=" + this.getStatus() + ", message=" + this.getMessage() + ", fields=" + this.getFields() + ")";
    }

    @Generated
    public ErrorResponse(Integer status, String message, @Nullable Map<String, List<String>> fields) {
        this.status = status;
        this.message = message;
        this.fields = fields;
    }

    @Generated
    public static class ErrorResponseBuilder {
        @Generated
        private Integer status;
        @Generated
        private String message;
        @Generated
        private ArrayList<String> fields$key;
        @Generated
        private ArrayList<List<String>> fields$value;

        @Generated
        ErrorResponseBuilder() {
        }

        @Generated
        public ErrorResponseBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        @Generated
        public ErrorResponseBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public ErrorResponseBuilder field(String fieldKey, List<String> fieldValue) {
            if (this.fields$key == null) {
                this.fields$key = new ArrayList();
                this.fields$value = new ArrayList();
            }
            this.fields$key.add(fieldKey);
            this.fields$value.add(fieldValue);
            return this;
        }

        @Generated
        public ErrorResponseBuilder fields(Map<? extends String, ? extends List<String>> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields$key == null) {
                this.fields$key = new ArrayList();
                this.fields$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends List<String>> $lombokEntry : fields.entrySet()) {
                this.fields$key.add($lombokEntry.getKey());
                this.fields$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public ErrorResponseBuilder clearFields() {
            if (this.fields$key != null) {
                this.fields$key.clear();
                this.fields$value.clear();
            }
            return this;
        }

        @Generated
        public ErrorResponse build() {
            Map<String, List<String>> fields;
            switch (this.fields$key == null ? 0 : this.fields$key.size()) {
                case 0: {
                    fields = Collections.emptyMap();
                    break;
                }
                case 1: {
                    fields = Collections.singletonMap(this.fields$key.get(0), this.fields$value.get(0));
                    break;
                }
                default: {
                    fields = new LinkedHashMap(this.fields$key.size() < 0x40000000 ? 1 + this.fields$key.size() + (this.fields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.fields$key.size(); ++$i) {
                        fields.put(this.fields$key.get($i), this.fields$value.get($i));
                    }
                    fields = Collections.unmodifiableMap(fields);
                }
            }
            return new ErrorResponse(this.status, this.message, fields);
        }

        @Generated
        public String toString() {
            return "ErrorResponse.ErrorResponseBuilder(status=" + this.status + ", message=" + this.message + ", fields$key=" + this.fields$key + ", fields$value=" + this.fields$value + ")";
        }
    }
}

