package io.rocketbase.commons.generator;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.TYPE;

@Target({TYPE, ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface ClientModule {

    /**
     * name of module that used as functional object with all it's controllers methods/hooks<br>
     * when not set use simple class name
     */
    String value() default "";

    /**
     * disable generation at all for this class/interface
     */
    boolean disable() default false;

}
