/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import io.rocketbase.commons.util.Nulls;

public final class StringShorten {
    public static String left(String value, int maxLength) {
        return StringShorten.left(value, maxLength, "...");
    }

    public static String left(String value, int maxLength, String end) {
        if (value == null) {
            return "";
        }
        if (value.length() < maxLength) {
            return value;
        }
        return value.substring(0, maxLength - Nulls.notEmpty(end, "").length()) + Nulls.notEmpty(end, "");
    }

    public static String right(String value, int maxLength) {
        return StringShorten.right(value, maxLength, "...");
    }

    public static String right(String value, int maxLength, String beginning) {
        if (value == null) {
            return "";
        }
        if (value.length() < maxLength) {
            return value;
        }
        return Nulls.notEmpty(beginning, "") + value.substring(value.length() - (maxLength - Nulls.notEmpty(beginning, "").length()));
    }
}

