/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.resource;

import io.rocketbase.commons.dto.PageableResult;
import io.rocketbase.commons.resource.AbstractBaseCrudRestResource;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractCrudRestResource<Read, Write, ID extends Serializable>
extends AbstractBaseCrudRestResource<Read, Write> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCrudRestResource.class);

    public void executeAll(Consumer<Read> execute, int batchSize) {
        PageableResult<Read> pageableResult;
        int page = 0;
        do {
            pageableResult = this.find(page++, batchSize);
            pageableResult.forEach(execute);
        } while (pageableResult.hasNextPage());
    }

    public PageableResult<Read> find(int page, int pagesize) {
        return this.find(this.appendParams(this.buildBaseUriBuilder(), (Pageable)PageRequest.of((int)page, (int)pagesize)));
    }

    public PageableResult<Read> find(Pageable pageable) {
        return this.find(this.appendParams(this.buildBaseUriBuilder(), pageable));
    }

    public Optional<Read> getById(ID id) {
        return this.getById((ID)this.buildBaseUriBuilder().path(String.valueOf(id)));
    }

    public Read create(Write write) {
        return this.create(UriComponentsBuilder.fromUriString((String)this.getBaseApiUrl()), write);
    }

    public Read update(ID id, Write write) {
        return this.update((ID)this.buildBaseUriBuilder().path(String.valueOf(id)), write);
    }

    public void delete(ID id) {
        this.delete((ID)this.buildBaseUriBuilder().path(String.valueOf(id)));
    }

    protected abstract String getBaseApiUrl();

    protected UriComponentsBuilder buildBaseUriBuilder() {
        return this.createUriComponentsBuilder(this.getBaseApiUrl());
    }
}

