/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.dto.address;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.rocketbase.commons.dto.address.Gender;
import io.rocketbase.commons.util.Nulls;
import java.io.Serializable;
import javax.validation.constraints.Email;
import javax.validation.constraints.Size;
import org.springframework.data.annotation.Transient;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class ContactDto
implements Serializable {
    @Nullable
    private Gender gender;
    @Size(max=10)
    @Nullable
    private @Size(max=10) String title;
    @Size(max=100)
    @Nullable
    private @Size(max=100) String firstName;
    @Size(max=100)
    @Nullable
    private @Size(max=100) String lastName;
    @Size(max=100)
    @Email
    @Nullable
    private @Size(max=100) @Email String email;
    @Size(max=50)
    @Nullable
    private @Size(max=50) String landline;
    @Size(max=50)
    @Nullable
    private @Size(max=50) String cellphone;

    @Transient
    @JsonIgnore
    public String getDisplayName() {
        String result = (Nulls.notNull(this.firstName) + " " + Nulls.notNull(this.lastName)).trim();
        if (StringUtils.isEmpty((Object)result) && !StringUtils.isEmpty((Object)this.email)) {
            result = this.email;
        }
        return result;
    }

    public static ContactDtoBuilder builder() {
        return new ContactDtoBuilder();
    }

    @Nullable
    public Gender getGender() {
        return this.gender;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getFirstName() {
        return this.firstName;
    }

    @Nullable
    public String getLastName() {
        return this.lastName;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public String getLandline() {
        return this.landline;
    }

    @Nullable
    public String getCellphone() {
        return this.cellphone;
    }

    public void setGender(@Nullable Gender gender) {
        this.gender = gender;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public void setFirstName(@Nullable String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(@Nullable String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    public void setLandline(@Nullable String landline) {
        this.landline = landline;
    }

    public void setCellphone(@Nullable String cellphone) {
        this.cellphone = cellphone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContactDto)) {
            return false;
        }
        ContactDto other = (ContactDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Gender this$gender = this.getGender();
        Gender other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)((Object)this$gender)).equals((Object)other$gender)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$landline = this.getLandline();
        String other$landline = other.getLandline();
        if (this$landline == null ? other$landline != null : !this$landline.equals(other$landline)) {
            return false;
        }
        String this$cellphone = this.getCellphone();
        String other$cellphone = other.getCellphone();
        return !(this$cellphone == null ? other$cellphone != null : !this$cellphone.equals(other$cellphone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContactDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Gender $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)((Object)$gender)).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $landline = this.getLandline();
        result = result * 59 + ($landline == null ? 43 : $landline.hashCode());
        String $cellphone = this.getCellphone();
        result = result * 59 + ($cellphone == null ? 43 : $cellphone.hashCode());
        return result;
    }

    public String toString() {
        return "ContactDto(gender=" + (Object)((Object)this.getGender()) + ", title=" + this.getTitle() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", landline=" + this.getLandline() + ", cellphone=" + this.getCellphone() + ")";
    }

    public ContactDto() {
    }

    public ContactDto(@Nullable Gender gender, @Nullable String title, @Nullable String firstName, @Nullable String lastName, @Nullable String email, @Nullable String landline, @Nullable String cellphone) {
        this.gender = gender;
        this.title = title;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.landline = landline;
        this.cellphone = cellphone;
    }

    public static class ContactDtoBuilder {
        private Gender gender;
        private String title;
        private String firstName;
        private String lastName;
        private String email;
        private String landline;
        private String cellphone;

        ContactDtoBuilder() {
        }

        public ContactDtoBuilder gender(@Nullable Gender gender) {
            this.gender = gender;
            return this;
        }

        public ContactDtoBuilder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public ContactDtoBuilder firstName(@Nullable String firstName) {
            this.firstName = firstName;
            return this;
        }

        public ContactDtoBuilder lastName(@Nullable String lastName) {
            this.lastName = lastName;
            return this;
        }

        public ContactDtoBuilder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        public ContactDtoBuilder landline(@Nullable String landline) {
            this.landline = landline;
            return this;
        }

        public ContactDtoBuilder cellphone(@Nullable String cellphone) {
            this.cellphone = cellphone;
            return this;
        }

        public ContactDto build() {
            return new ContactDto(this.gender, this.title, this.firstName, this.lastName, this.email, this.landline, this.cellphone);
        }

        public String toString() {
            return "ContactDto.ContactDtoBuilder(gender=" + (Object)((Object)this.gender) + ", title=" + this.title + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", landline=" + this.landline + ", cellphone=" + this.cellphone + ")";
        }
    }
}

