/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class PageableResult<E>
implements Iterable<E>,
Serializable {
    private long totalElements;
    private int totalPages;
    private int page;
    private int pageSize;
    private List<E> content;

    public static <E> PageableResult<E> contentPage(List<E> content, Page page) {
        PageableResult<E> result = new PageableResult<E>();
        result.setContent(content);
        result.setTotalPages(page.getTotalPages());
        result.setTotalElements(page.getTotalElements());
        result.setPage(page.getNumber());
        result.setPageSize(page.getSize());
        return result;
    }

    public static <E> PageableResult<E> page(Page<E> page) {
        PageableResult<E> result = new PageableResult<E>();
        result.setContent(page.getContent());
        result.setTotalPages(page.getTotalPages());
        result.setTotalElements(page.getTotalElements());
        result.setPage(page.getNumber());
        result.setPageSize(page.getSize());
        return result;
    }

    public static <E> PageableResult<E> content(List<E> content) {
        PageableResult<E> result = new PageableResult<E>();
        result.setContent(content);
        result.setTotalPages(1);
        int totalElements = content != null ? content.size() : 0;
        result.setTotalElements(totalElements);
        result.setPage(0);
        result.setPageSize(totalElements);
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return this.content.iterator();
    }

    @JsonIgnore
    public boolean hasNextPage() {
        return this.page < this.totalPages - 1;
    }

    @JsonIgnore
    public Page<E> toPage() {
        return new PageImpl(this.getContent(), (Pageable)PageRequest.of((int)this.page, (int)this.pageSize), this.totalElements);
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<E> getContent() {
        return this.content;
    }

    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setContent(List<E> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageableResult)) {
            return false;
        }
        PageableResult other = (PageableResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalElements() != other.getTotalElements()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        List<E> this$content = this.getContent();
        List<E> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageableResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalElements = this.getTotalElements();
        result = result * 59 + (int)($totalElements >>> 32 ^ $totalElements);
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getPage();
        result = result * 59 + this.getPageSize();
        List<E> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "PageableResult(totalElements=" + this.getTotalElements() + ", totalPages=" + this.getTotalPages() + ", page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ", content=" + this.getContent() + ")";
    }
}

