/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public final class UrlParts {
    public static String concatPaths(Object ... parts) {
        String result = "";
        if (parts != null) {
            for (Object p : parts) {
                String str = String.valueOf(p);
                if (p == null || StringUtils.isEmpty((Object)str)) continue;
                if (result.length() > 0 && !str.startsWith("/") && !result.endsWith("/")) {
                    result = result + "/";
                }
                result = result + str;
            }
        }
        return result;
    }

    public static String ensureEndsWithSlash(String uri) {
        if (uri == null) {
            return "/";
        }
        if (!uri.endsWith("/")) {
            return String.format("%s/", uri);
        }
        return uri;
    }

    public static String ensureStartsWithSlash(String uri) {
        if (uri == null) {
            return "/";
        }
        if (!uri.startsWith("/")) {
            return String.format("/%s", uri);
        }
        return uri;
    }

    public static String ensureStartsAndEndsWithSlash(String path) {
        String fixedStart = UrlParts.ensureStartsWithSlash(path);
        return UrlParts.ensureEndsWithSlash(fixedStart);
    }

    public static String getBaseUrl(HttpServletRequest request) {
        String result = request.getScheme() + "://" + request.getServerName();
        int serverPort = request.getServerPort();
        if (serverPort != 80 && serverPort != 443) {
            result = result + ":" + serverPort;
        }
        if ((result = result + request.getContextPath()).endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

