/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Nulls {
    public static <T> T notNull(T value, T fallback) {
        if (value == null) {
            return fallback;
        }
        return value;
    }

    public static String notNull(String value) {
        return Nulls.notNull(value, "");
    }

    public static <T> List<T> notNull(List<T> value) {
        if (value == null) {
            return new ArrayList();
        }
        return value;
    }

    public static <T> Set<T> notNull(Set<T> value) {
        if (value == null) {
            return new HashSet();
        }
        return value;
    }

    public static <K, V> Map<K, V> notNull(Map<K, V> value) {
        if (value == null) {
            return new HashMap();
        }
        return value;
    }

    public static <T> void accept(T value, Consumer<T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    public static <T, R> R apply(T value, Function<T, R> function, R fallback) {
        if (value != null) {
            return function.apply(value);
        }
        return fallback;
    }

    public static String notEmpty(String value, String fallback) {
        if (value == null || value.trim().isEmpty()) {
            return fallback;
        }
        return value;
    }

    public static <TARGET, SOURCE> TARGET notNull(SOURCE value, PropertyValueProvider<SOURCE, TARGET> provider, TARGET fallback) {
        if (value == null) {
            return fallback;
        }
        TARGET result = provider.apply(value);
        return Nulls.notNull(result, fallback);
    }

    public static <SOURCE> String notEmpty(SOURCE value, PropertyValueProvider<SOURCE, String> provider, String fallback) {
        if (value == null) {
            return fallback;
        }
        String result = provider.apply(value);
        return Nulls.notEmpty(result, fallback);
    }

    public static <T> boolean noneNullValue(T ... values) {
        for (T v : values) {
            if (v != null) continue;
            return false;
        }
        return true;
    }

    public static interface PropertyValueProvider<SOURCE, TARGET> {
        public TARGET apply(SOURCE var1);
    }
}

