/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;

public abstract class LocaleFilter {
    public static <T> Optional<Map.Entry<Locale, T>> findClosestOptional(Locale filter, Map<Locale, T> values) {
        return Optional.ofNullable(LocaleFilter.findClosest(filter, values));
    }

    public static <T> Map.Entry<Locale, T> findClosest(Locale filter, Map<Locale, T> values) {
        return LocaleFilter.findClosest(filter, values, null);
    }

    public static <T> Optional<Map.Entry<Locale, T>> findClosestOptional(Locale filter, Map<Locale, T> values, Locale fallback) {
        return Optional.ofNullable(LocaleFilter.findClosest(filter, values, fallback));
    }

    public static <T> Map.Entry<Locale, T> findClosest(Locale filter, Map<Locale, T> values, Locale fallback) {
        if (filter != null && values != null) {
            if (values.containsKey(filter)) {
                return new AbstractMap.SimpleEntry<Locale, T>(filter, values.get(filter));
            }
            if (!StringUtils.isEmpty((Object)filter.getLanguage())) {
                Locale language = Locale.forLanguageTag(filter.getLanguage());
                if (!StringUtils.isEmpty((Object)filter.getCountry()) && values.containsKey(language)) {
                    return new AbstractMap.SimpleEntry<Locale, T>(language, values.get(language));
                }
                Optional<Map.Entry<Locale, Locale>> optional = LocaleFilter.transformMapFilterByLanguage(values, language);
                if (optional.isPresent()) {
                    return new AbstractMap.SimpleEntry<Locale, T>(optional.get().getKey(), values.get(optional.get().getKey()));
                }
            }
        }
        if (values != null && fallback != null) {
            return LocaleFilter.findClosest(fallback, values, !fallback.equals(Locale.ROOT) ? Locale.ROOT : null);
        }
        return null;
    }

    protected static Optional<Map.Entry<Locale, Locale>> transformMapFilterByLanguage(Map<Locale, ?> values, Locale language) {
        return values.keySet().stream().filter(l -> !StringUtils.isEmpty((Object)l.getLanguage())).map(l -> new AbstractMap.SimpleEntry<Locale, Locale>((Locale)l, Locale.forLanguageTag(l.getLanguage()))).filter(l -> ((Locale)l.getValue()).equals(language)).findFirst();
    }
}

