/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.resource;

import io.rocketbase.commons.util.QueryParamBuilder;
import io.rocketbase.commons.util.UrlParts;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.web.util.UriComponentsBuilder;

public interface BaseRestResource {
    default public UriComponentsBuilder appendParams(UriComponentsBuilder uriBuilder, Pageable pageable) {
        return QueryParamBuilder.appendParams(uriBuilder, pageable);
    }

    default public HttpHeaders createHeaderWithLanguage() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept-Language", LocaleContextHolder.getLocale().getLanguage());
        return headers;
    }

    default public String ensureEndsWithSlash(String uri) {
        return UrlParts.ensureEndsWithSlash(uri);
    }

    default public String ensureStartsWithSlash(String uri) {
        return UrlParts.ensureEndsWithSlash(uri);
    }

    default public String ensureStartsAndEndsWithSlash(String uri) {
        return UrlParts.ensureStartsAndEndsWithSlash(uri);
    }

    default public UriComponentsBuilder createUriComponentsBuilder(String baseApiUrl) {
        return UriComponentsBuilder.fromUriString((String)this.ensureEndsWithSlash(baseApiUrl));
    }
}

