/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.resource;

import io.rocketbase.commons.dto.PageableResult;
import io.rocketbase.commons.resource.AbstractBaseCrudRestResource;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractCrudChildRestResource<Read, Write, ID extends Serializable>
extends AbstractBaseCrudRestResource<Read, Write> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCrudChildRestResource.class);

    public PageableResult<Read> find(ID parentId, int page, int pagesize) {
        return this.find(this.appendParams(this.buildBaseUriBuilder(parentId), (Pageable)PageRequest.of((int)page, (int)pagesize)));
    }

    public PageableResult<Read> find(ID parentId, Pageable pageable) {
        return this.find(this.appendParams(this.buildBaseUriBuilder(parentId), pageable));
    }

    public Optional<Read> getById(ID parentId, ID id) {
        return this.getById(this.buildBaseUriBuilder(parentId).path(String.valueOf(id)));
    }

    public Read create(ID parentId, Write write) {
        return this.create((ID)this.buildBaseUriBuilder(parentId), write);
    }

    public Read update(ID parentId, ID id, Write write) {
        return this.update(this.buildBaseUriBuilder(parentId).path(String.valueOf(id)), write);
    }

    public void delete(ID parentId, ID id) {
        this.delete(this.buildBaseUriBuilder(parentId).path(String.valueOf(id)));
    }

    protected UriComponentsBuilder buildBaseUriBuilder(ID parentId) {
        UriComponentsBuilder builder = this.createUriComponentsBuilder(this.getBaseParentApiUrl());
        builder.path(String.valueOf(parentId));
        builder.path(this.ensureStartsAndEndsWithSlash(this.getChildPath()));
        return builder;
    }

    protected abstract String getBaseParentApiUrl();

    protected abstract String getChildPath();
}

