/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.resource;

import io.rocketbase.commons.dto.PageableResult;
import io.rocketbase.commons.exception.NotFoundException;
import io.rocketbase.commons.resource.BaseRestResource;
import io.rocketbase.commons.resource.BasicResponseErrorHandler;
import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractBaseCrudRestResource<Read, Write>
implements BaseRestResource {
    protected Class<Read> responseClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private RestTemplate restTemplate;

    protected RestTemplate getRestTemplate() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new BasicResponseErrorHandler());
        }
        return this.restTemplate;
    }

    protected PageableResult<Read> find(UriComponentsBuilder uriBuilder) {
        ResponseEntity response = this.getRestTemplate().exchange(uriBuilder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.createHeaderWithLanguage()), this.createPagedTypeReference(), new Object[0]);
        return (PageableResult)response.getBody();
    }

    protected Optional<Read> getById(UriComponentsBuilder uriBuilder) {
        try {
            ResponseEntity response = this.getRestTemplate().exchange(uriBuilder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)this.createHeaderWithLanguage()), this.responseClass, new Object[0]);
            return Optional.of(response.getBody());
        }
        catch (NotFoundException notFound) {
            return Optional.empty();
        }
    }

    protected Read create(UriComponentsBuilder uriBuilder, Write write) {
        ResponseEntity response = this.getRestTemplate().exchange(uriBuilder.toUriString(), HttpMethod.POST, this.createHttpEntity(write), this.responseClass, new Object[0]);
        return (Read)response.getBody();
    }

    protected Read update(UriComponentsBuilder uriBuilder, Write write) {
        ResponseEntity response = this.getRestTemplate().exchange(uriBuilder.toUriString(), HttpMethod.PUT, this.createHttpEntity(write), this.responseClass, new Object[0]);
        return (Read)response.getBody();
    }

    protected void delete(UriComponentsBuilder uriBuilder) {
        ResponseEntity response = this.getRestTemplate().exchange(uriBuilder.toUriString(), HttpMethod.DELETE, null, Void.class, new Object[0]);
    }

    protected HttpEntity<Write> createHttpEntity(Write write) {
        HttpEntity entity = new HttpEntity(write, (MultiValueMap)this.createHeaderWithLanguage());
        return entity;
    }

    protected abstract ParameterizedTypeReference<PageableResult<Read>> createPagedTypeReference();

    public Class<Read> getResponseClass() {
        return this.responseClass;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

