/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.test.model;

import com.google.common.collect.ImmutableMap;
import io.rocketbase.commons.model.AppUserEntity;
import io.rocketbase.commons.util.RolesAuthoritiesConverter;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;

public class AppUserTestEntity
implements AppUserEntity {
    private String id;
    private String username;
    private String firstName;
    private String lastName;
    private String password;
    private String email;
    private String avatar;
    private List<String> roles;
    private Map<String, String> keyValueMap;
    private boolean enabled;
    private Instant created;
    private Instant lastLogin;
    private Instant lastTokenInvalidation;

    public void updateLastLogin() {
        this.lastLogin = Instant.now();
    }

    public void updateLastTokenInvalidation() {
        this.lastTokenInvalidation = Instant.now();
    }

    public AppUserTestEntity clone() {
        HashMap<String, String> copyedKeyValueMap = this.getKeyValueMap() != null ? new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(this.getKeyValueMap())) : null;
        return AppUserTestEntity.builder().id(this.getId()).username(this.getUsername()).password(this.getPassword()).email(this.getEmail()).enabled(this.isEnabled()).roles(this.getRoles() != null ? this.getRoles().stream().map(r -> String.valueOf(r)).collect(Collectors.toList()) : null).firstName(this.getFirstName()).lastName(this.getLastName()).avatar(this.getAvatar()).created(this.getCreated()).lastLogin(this.getLastLogin()).lastTokenInvalidation(this.getLastTokenInvalidation()).keyValueMap(copyedKeyValueMap).build();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return RolesAuthoritiesConverter.convert(this.getRoles());
    }

    public Map<String, String> getKeyValues() {
        return this.keyValueMap;
    }

    public void setKeyValues(Map<String, String> map) {
        this.keyValueMap = map;
    }

    @Generated
    private static Map<String, String> $default$keyValueMap() {
        return new HashMap<String, String>();
    }

    @Generated
    public static AppUserTestEntityBuilder builder() {
        return new AppUserTestEntityBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getAvatar() {
        return this.avatar;
    }

    @Generated
    public List<String> getRoles() {
        return this.roles;
    }

    @Generated
    public Map<String, String> getKeyValueMap() {
        return this.keyValueMap;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public Instant getLastLogin() {
        return this.lastLogin;
    }

    @Generated
    public Instant getLastTokenInvalidation() {
        return this.lastTokenInvalidation;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @Generated
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @Generated
    public void setKeyValueMap(Map<String, String> keyValueMap) {
        this.keyValueMap = keyValueMap;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setCreated(Instant created) {
        this.created = created;
    }

    @Generated
    public void setLastLogin(Instant lastLogin) {
        this.lastLogin = lastLogin;
    }

    @Generated
    public void setLastTokenInvalidation(Instant lastTokenInvalidation) {
        this.lastTokenInvalidation = lastTokenInvalidation;
    }

    @Generated
    public String toString() {
        return "AppUserTestEntity(id=" + this.getId() + ", username=" + this.getUsername() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", avatar=" + this.getAvatar() + ", roles=" + this.getRoles() + ", keyValueMap=" + this.getKeyValueMap() + ", enabled=" + this.isEnabled() + ", created=" + this.getCreated() + ", lastLogin=" + this.getLastLogin() + ", lastTokenInvalidation=" + this.getLastTokenInvalidation() + ")";
    }

    @Generated
    public AppUserTestEntity(String id, String username, String firstName, String lastName, String password, String email, String avatar, List<String> roles, Map<String, String> keyValueMap, boolean enabled, Instant created, Instant lastLogin, Instant lastTokenInvalidation) {
        this.id = id;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.password = password;
        this.email = email;
        this.avatar = avatar;
        this.roles = roles;
        this.keyValueMap = keyValueMap;
        this.enabled = enabled;
        this.created = created;
        this.lastLogin = lastLogin;
        this.lastTokenInvalidation = lastTokenInvalidation;
    }

    @Generated
    public AppUserTestEntity() {
        this.keyValueMap = AppUserTestEntity.$default$keyValueMap();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppUserTestEntity)) {
            return false;
        }
        AppUserTestEntity other = (AppUserTestEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AppUserTestEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public static class AppUserTestEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String username;
        @Generated
        private String firstName;
        @Generated
        private String lastName;
        @Generated
        private String password;
        @Generated
        private String email;
        @Generated
        private String avatar;
        @Generated
        private List<String> roles;
        @Generated
        private boolean keyValueMap$set;
        @Generated
        private Map<String, String> keyValueMap$value;
        @Generated
        private boolean enabled;
        @Generated
        private Instant created;
        @Generated
        private Instant lastLogin;
        @Generated
        private Instant lastTokenInvalidation;

        @Generated
        AppUserTestEntityBuilder() {
        }

        @Generated
        public AppUserTestEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder email(String email) {
            this.email = email;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder keyValueMap(Map<String, String> keyValueMap) {
            this.keyValueMap$value = keyValueMap;
            this.keyValueMap$set = true;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder created(Instant created) {
            this.created = created;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder lastLogin(Instant lastLogin) {
            this.lastLogin = lastLogin;
            return this;
        }

        @Generated
        public AppUserTestEntityBuilder lastTokenInvalidation(Instant lastTokenInvalidation) {
            this.lastTokenInvalidation = lastTokenInvalidation;
            return this;
        }

        @Generated
        public AppUserTestEntity build() {
            Map keyValueMap$value = this.keyValueMap$value;
            if (!this.keyValueMap$set) {
                keyValueMap$value = AppUserTestEntity.$default$keyValueMap();
            }
            return new AppUserTestEntity(this.id, this.username, this.firstName, this.lastName, this.password, this.email, this.avatar, this.roles, keyValueMap$value, this.enabled, this.created, this.lastLogin, this.lastTokenInvalidation);
        }

        @Generated
        public String toString() {
            return "AppUserTestEntity.AppUserTestEntityBuilder(id=" + this.id + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", password=" + this.password + ", email=" + this.email + ", avatar=" + this.avatar + ", roles=" + this.roles + ", keyValueMap$value=" + this.keyValueMap$value + ", enabled=" + this.enabled + ", created=" + this.created + ", lastLogin=" + this.lastLogin + ", lastTokenInvalidation=" + this.lastTokenInvalidation + ")";
        }
    }
}

