/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.test.model;

import com.google.common.collect.ImmutableMap;
import io.rocketbase.commons.model.AppUserEntity;
import io.rocketbase.commons.util.RolesAuthoritiesConverter;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;

public class AppUserTestEntity
implements AppUserEntity {
    private String id;
    private String username;
    private String firstName;
    private String lastName;
    private String password;
    private String email;
    private String avatar;
    private List<String> roles;
    private Map<String, String> keyValueMap;
    private boolean enabled;
    private Instant created;
    private Instant lastLogin;
    private Instant lastTokenInvalidation;

    public void updateLastLogin() {
        this.lastLogin = Instant.now();
    }

    public void updateLastTokenInvalidation() {
        this.lastTokenInvalidation = Instant.now();
    }

    public AppUserTestEntity clone() {
        HashMap<String, String> copyedKeyValueMap = this.getKeyValueMap() != null ? new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(this.getKeyValueMap())) : null;
        return AppUserTestEntity.builder().id(this.getId()).username(this.getUsername()).password(this.getPassword()).email(this.getEmail()).enabled(this.isEnabled()).roles(this.getRoles() != null ? this.getRoles().stream().map(r -> String.valueOf(r)).collect(Collectors.toList()) : null).firstName(this.getFirstName()).lastName(this.getLastName()).avatar(this.getAvatar()).created(this.getCreated()).lastLogin(this.getLastLogin()).lastTokenInvalidation(this.getLastTokenInvalidation()).keyValueMap(copyedKeyValueMap).build();
    }

    public AppUserEntity addKeyValue(String key, String value) {
        this.checkKeyValue(key, value);
        this.keyValueMap.put(key.toLowerCase(), value);
        return this;
    }

    public void removeKeyValue(String key) {
        this.keyValueMap.remove(key.toLowerCase());
    }

    public Map<String, String> getKeyValues() {
        return this.keyValueMap != null ? ImmutableMap.copyOf(this.keyValueMap) : null;
    }

    public boolean hasKeyValue(String key) {
        return this.keyValueMap != null && key != null && this.keyValueMap.containsKey(key.toLowerCase());
    }

    public String getKeyValue(String key) {
        return this.keyValueMap != null && key != null ? (String)this.keyValueMap.getOrDefault(key.toLowerCase(), null) : null;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return RolesAuthoritiesConverter.convert(this.getRoles());
    }

    private static Map<String, String> $default$keyValueMap() {
        return new HashMap<String, String>();
    }

    public static AppUserTestEntityBuilder builder() {
        return new AppUserTestEntityBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Map<String, String> getKeyValueMap() {
        return this.keyValueMap;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Instant getCreated() {
        return this.created;
    }

    public Instant getLastLogin() {
        return this.lastLogin;
    }

    public Instant getLastTokenInvalidation() {
        return this.lastTokenInvalidation;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setKeyValueMap(Map<String, String> keyValueMap) {
        this.keyValueMap = keyValueMap;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setLastLogin(Instant lastLogin) {
        this.lastLogin = lastLogin;
    }

    public void setLastTokenInvalidation(Instant lastTokenInvalidation) {
        this.lastTokenInvalidation = lastTokenInvalidation;
    }

    public String toString() {
        return "AppUserTestEntity(id=" + this.getId() + ", username=" + this.getUsername() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", avatar=" + this.getAvatar() + ", roles=" + this.getRoles() + ", keyValueMap=" + this.getKeyValueMap() + ", enabled=" + this.isEnabled() + ", created=" + this.getCreated() + ", lastLogin=" + this.getLastLogin() + ", lastTokenInvalidation=" + this.getLastTokenInvalidation() + ")";
    }

    public AppUserTestEntity(String id, String username, String firstName, String lastName, String password, String email, String avatar, List<String> roles, Map<String, String> keyValueMap, boolean enabled, Instant created, Instant lastLogin, Instant lastTokenInvalidation) {
        this.id = id;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.password = password;
        this.email = email;
        this.avatar = avatar;
        this.roles = roles;
        this.keyValueMap = keyValueMap;
        this.enabled = enabled;
        this.created = created;
        this.lastLogin = lastLogin;
        this.lastTokenInvalidation = lastTokenInvalidation;
    }

    public AppUserTestEntity() {
        this.keyValueMap = AppUserTestEntity.$default$keyValueMap();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppUserTestEntity)) {
            return false;
        }
        AppUserTestEntity other = (AppUserTestEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppUserTestEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public static class AppUserTestEntityBuilder {
        private String id;
        private String username;
        private String firstName;
        private String lastName;
        private String password;
        private String email;
        private String avatar;
        private List<String> roles;
        private boolean keyValueMap$set;
        private Map<String, String> keyValueMap$value;
        private boolean enabled;
        private Instant created;
        private Instant lastLogin;
        private Instant lastTokenInvalidation;

        AppUserTestEntityBuilder() {
        }

        public AppUserTestEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AppUserTestEntityBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AppUserTestEntityBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public AppUserTestEntityBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public AppUserTestEntityBuilder password(String password) {
            this.password = password;
            return this;
        }

        public AppUserTestEntityBuilder email(String email) {
            this.email = email;
            return this;
        }

        public AppUserTestEntityBuilder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public AppUserTestEntityBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public AppUserTestEntityBuilder keyValueMap(Map<String, String> keyValueMap) {
            this.keyValueMap$value = keyValueMap;
            this.keyValueMap$set = true;
            return this;
        }

        public AppUserTestEntityBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public AppUserTestEntityBuilder created(Instant created) {
            this.created = created;
            return this;
        }

        public AppUserTestEntityBuilder lastLogin(Instant lastLogin) {
            this.lastLogin = lastLogin;
            return this;
        }

        public AppUserTestEntityBuilder lastTokenInvalidation(Instant lastTokenInvalidation) {
            this.lastTokenInvalidation = lastTokenInvalidation;
            return this;
        }

        public AppUserTestEntity build() {
            Map keyValueMap$value = this.keyValueMap$value;
            if (!this.keyValueMap$set) {
                keyValueMap$value = AppUserTestEntity.$default$keyValueMap();
            }
            return new AppUserTestEntity(this.id, this.username, this.firstName, this.lastName, this.password, this.email, this.avatar, this.roles, keyValueMap$value, this.enabled, this.created, this.lastLogin, this.lastTokenInvalidation);
        }

        public String toString() {
            return "AppUserTestEntity.AppUserTestEntityBuilder(id=" + this.id + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", password=" + this.password + ", email=" + this.email + ", avatar=" + this.avatar + ", roles=" + this.roles + ", keyValueMap$value=" + this.keyValueMap$value + ", enabled=" + this.enabled + ", created=" + this.created + ", lastLogin=" + this.lastLogin + ", lastTokenInvalidation=" + this.lastTokenInvalidation + ")";
        }
    }
}

