/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.test.model;

import com.google.common.collect.ImmutableMap;
import io.rocketbase.commons.model.AppInviteEntity;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AppInviteTestEntity
implements AppInviteEntity {
    private String id;
    private String invitor;
    private String message;
    private String firstName;
    private String lastName;
    private String email;
    private List<String> roles;
    private Map<String, String> keyValueMap;
    private Instant created;
    private Instant expiration;

    public AppInviteTestEntity clone() {
        HashMap<String, String> copyedKeyValueMap = this.getKeyValueMap() != null ? new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(this.getKeyValueMap())) : null;
        return AppInviteTestEntity.builder().id(this.getId()).invitor(this.getInvitor()).message(this.getMessage()).email(this.getEmail()).roles(this.getRoles() != null ? this.getRoles().stream().map(r -> String.valueOf(r)).collect(Collectors.toList()) : null).firstName(this.getFirstName()).lastName(this.getLastName()).created(this.getCreated()).expiration(this.getExpiration()).keyValueMap(copyedKeyValueMap).build();
    }

    public AppInviteEntity addKeyValue(String key, String value) {
        this.checkKeyValue(key, value);
        this.keyValueMap.put(key.toLowerCase(), value);
        return this;
    }

    public void removeKeyValue(String key) {
        this.keyValueMap.remove(key.toLowerCase());
    }

    public Map<String, String> getKeyValues() {
        return this.keyValueMap != null ? ImmutableMap.copyOf(this.keyValueMap) : null;
    }

    public boolean hasKeyValue(String key) {
        return this.keyValueMap != null && key != null && this.keyValueMap.containsKey(key.toLowerCase());
    }

    public String getKeyValue(String key) {
        return this.keyValueMap != null && key != null ? (String)this.keyValueMap.getOrDefault(key.toLowerCase(), null) : null;
    }

    private static Map<String, String> $default$keyValueMap() {
        return new HashMap<String, String>();
    }

    public static AppInviteTestEntityBuilder builder() {
        return new AppInviteTestEntityBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getInvitor() {
        return this.invitor;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public Map<String, String> getKeyValueMap() {
        return this.keyValueMap;
    }

    public Instant getCreated() {
        return this.created;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInvitor(String invitor) {
        this.invitor = invitor;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setKeyValueMap(Map<String, String> keyValueMap) {
        this.keyValueMap = keyValueMap;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setExpiration(Instant expiration) {
        this.expiration = expiration;
    }

    public String toString() {
        return "AppInviteTestEntity(id=" + this.getId() + ", invitor=" + this.getInvitor() + ", message=" + this.getMessage() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", roles=" + this.getRoles() + ", keyValueMap=" + this.getKeyValueMap() + ", created=" + this.getCreated() + ", expiration=" + this.getExpiration() + ")";
    }

    public AppInviteTestEntity(String id, String invitor, String message, String firstName, String lastName, String email, List<String> roles, Map<String, String> keyValueMap, Instant created, Instant expiration) {
        this.id = id;
        this.invitor = invitor;
        this.message = message;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.roles = roles;
        this.keyValueMap = keyValueMap;
        this.created = created;
        this.expiration = expiration;
    }

    public AppInviteTestEntity() {
        this.keyValueMap = AppInviteTestEntity.$default$keyValueMap();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppInviteTestEntity)) {
            return false;
        }
        AppInviteTestEntity other = (AppInviteTestEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppInviteTestEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public static class AppInviteTestEntityBuilder {
        private String id;
        private String invitor;
        private String message;
        private String firstName;
        private String lastName;
        private String email;
        private List<String> roles;
        private boolean keyValueMap$set;
        private Map<String, String> keyValueMap$value;
        private Instant created;
        private Instant expiration;

        AppInviteTestEntityBuilder() {
        }

        public AppInviteTestEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AppInviteTestEntityBuilder invitor(String invitor) {
            this.invitor = invitor;
            return this;
        }

        public AppInviteTestEntityBuilder message(String message) {
            this.message = message;
            return this;
        }

        public AppInviteTestEntityBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public AppInviteTestEntityBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public AppInviteTestEntityBuilder email(String email) {
            this.email = email;
            return this;
        }

        public AppInviteTestEntityBuilder roles(List<String> roles) {
            this.roles = roles;
            return this;
        }

        public AppInviteTestEntityBuilder keyValueMap(Map<String, String> keyValueMap) {
            this.keyValueMap$value = keyValueMap;
            this.keyValueMap$set = true;
            return this;
        }

        public AppInviteTestEntityBuilder created(Instant created) {
            this.created = created;
            return this;
        }

        public AppInviteTestEntityBuilder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public AppInviteTestEntity build() {
            Map keyValueMap$value = this.keyValueMap$value;
            if (!this.keyValueMap$set) {
                keyValueMap$value = AppInviteTestEntity.$default$keyValueMap();
            }
            return new AppInviteTestEntity(this.id, this.invitor, this.message, this.firstName, this.lastName, this.email, this.roles, keyValueMap$value, this.created, this.expiration);
        }

        public String toString() {
            return "AppInviteTestEntity.AppInviteTestEntityBuilder(id=" + this.id + ", invitor=" + this.invitor + ", message=" + this.message + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", roles=" + this.roles + ", keyValueMap$value=" + this.keyValueMap$value + ", created=" + this.created + ", expiration=" + this.expiration + ")";
        }
    }
}

