/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.test;

import io.rocketbase.commons.dto.appinvite.QueryAppInvite;
import io.rocketbase.commons.service.AppInvitePersistenceService;
import io.rocketbase.commons.test.model.AppInviteTestEntity;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class AppInvitePersistenceTestService
implements AppInvitePersistenceService<AppInviteTestEntity> {
    private Map<String, AppInviteTestEntity> inviteMap = new HashMap<String, AppInviteTestEntity>();

    private AppInviteTestEntity buildAppInvite(String email, String role) {
        return AppInviteTestEntity.builder().id(UUID.randomUUID().toString()).email(email).roles(Arrays.asList(role)).created(Instant.now()).expiration(Instant.now().plusSeconds(3600L)).build();
    }

    @PostConstruct
    public void init() {
        this.resetData();
    }

    public void resetData() {
        this.inviteMap.clear();
        AppInviteTestEntity sampleInvite = this.buildAppInvite("sample@rocketbase.io", "USER");
        this.inviteMap.put(sampleInvite.getId(), sampleInvite);
    }

    public Page<AppInviteTestEntity> findAll(QueryAppInvite query, Pageable pageable) {
        return new PageImpl(new ArrayList<AppInviteTestEntity>(this.inviteMap.values()), pageable, (long)this.inviteMap.size());
    }

    public AppInviteTestEntity save(AppInviteTestEntity entity) {
        this.inviteMap.put(entity.getId(), entity);
        return this.inviteMap.get(entity.getId());
    }

    public Optional<AppInviteTestEntity> findById(String id) {
        for (AppInviteTestEntity invite : this.inviteMap.values()) {
            if (!id.equals(invite.getId())) continue;
            return Optional.of(invite.clone());
        }
        return Optional.empty();
    }

    public long count() {
        return this.inviteMap.size();
    }

    public void delete(AppInviteTestEntity entity) {
        this.inviteMap.remove(entity.getId());
    }

    public void deleteAll() {
    }

    public AppInviteTestEntity initNewInstance() {
        return AppInviteTestEntity.builder().id(UUID.randomUUID().toString()).created(Instant.now()).roles(new ArrayList<String>()).build();
    }

    public long deleteExpired() {
        return 0L;
    }
}

