/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.test.adapters;

import io.rocketbase.commons.model.AppUserToken;
import io.rocketbase.commons.resource.BasicResponseErrorHandler;
import io.rocketbase.commons.security.JwtTokenService;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class AuthRestTestTemplate
extends RestTemplate {
    public AuthRestTestTemplate(AppUserToken userToken, JwtTokenService jwtTokenService) {
        super((ClientHttpRequestFactory)new TestClientHttpRequestFactory(userToken, jwtTokenService));
        this.setErrorHandler((ResponseErrorHandler)new BasicResponseErrorHandler());
    }

    protected static class TestClientHttpRequestFactory
    extends HttpComponentsClientHttpRequestFactory
    implements ClientHttpRequestFactory {
        private final AppUserToken userToken;
        private final JwtTokenService jwtTokenService;

        protected void postProcessHttpRequest(HttpUriRequest request) {
            request.setHeader("Authorization", "Bearer " + this.jwtTokenService.generateAccessToken(this.userToken));
        }

        public TestClientHttpRequestFactory(AppUserToken userToken, JwtTokenService jwtTokenService) {
            this.userToken = userToken;
            this.jwtTokenService = jwtTokenService;
        }
    }
}

