/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.test;

import io.rocketbase.commons.model.AppUserEntity;
import io.rocketbase.commons.model.AppUserToken;
import io.rocketbase.commons.security.JwtTokenService;
import io.rocketbase.commons.test.AppUserPersistenceTestService;
import io.rocketbase.commons.test.adapters.AuthRestTestTemplate;
import javax.annotation.Resource;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(profiles={"test"})
public abstract class BaseIntegrationTest {
    @Value(value="http://localhost:${local.server.port}")
    protected String baseUrl;
    @Resource
    private AppUserPersistenceTestService appUserPersistenceTestService;
    @Resource
    private JwtTokenService jwtTokenService;

    protected AppUserEntity getAppUser() {
        return this.getAppUser("user");
    }

    protected AppUserEntity getAppAdminUser() {
        return this.getAppUser("admin");
    }

    protected AppUserEntity getAppUser(String username) {
        return this.appUserPersistenceTestService.findByUsername(username).get();
    }

    protected AuthRestTestTemplate getAuthRestTemplate() {
        return this.getAuthRestTemplate("user");
    }

    protected AuthRestTestTemplate getAuthRestAdminTemplate() {
        return this.getAuthRestTemplate("admin");
    }

    protected AuthRestTestTemplate getAuthRestTemplate(String username) {
        return new AuthRestTestTemplate((AppUserToken)this.getAppUser(username), this.jwtTokenService);
    }

    @Before
    public void beforeEachTest() {
        this.appUserPersistenceTestService.resetData();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

