/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.test;

import io.rocketbase.commons.config.AuthProperties;
import io.rocketbase.commons.dto.appuser.QueryAppUser;
import io.rocketbase.commons.service.AppUserPersistenceService;
import io.rocketbase.commons.test.model.AppUserTestEntity;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;

public class AppUserPersistenceTestService
implements AppUserPersistenceService<AppUserTestEntity> {
    private Map<String, AppUserTestEntity> userMap = new HashMap<String, AppUserTestEntity>();
    @Resource
    private PasswordEncoder passwordEncoder;

    private AppUserTestEntity buildAppUser(String username, String role, String email) {
        return AppUserTestEntity.builder().id(UUID.randomUUID().toString()).username(username).password(this.passwordEncoder.encode((CharSequence)"pw")).email(email).enabled(true).roles(Arrays.asList(role)).build();
    }

    @PostConstruct
    public void init() {
        this.resetData();
    }

    public void resetData() {
        this.userMap.clear();
        AuthProperties authProperties = new AuthProperties();
        this.userMap.put("user", this.buildAppUser("user", authProperties.getRoleUser(), "user@rocketbase.io"));
        this.userMap.put("admin", this.buildAppUser("admin", authProperties.getRoleAdmin(), "user@rocketbase.io"));
        AppUserTestEntity disabled = this.buildAppUser("disabled", authProperties.getRoleAdmin(), "disabled@rocketbase.io");
        disabled.setEnabled(false);
        this.userMap.put("disabled", disabled);
    }

    public Optional<AppUserTestEntity> findByUsername(String username) {
        return this.userMap.containsKey(username) ? Optional.of(this.userMap.get(username).clone()) : Optional.empty();
    }

    public Optional<AppUserTestEntity> findByEmail(String email) {
        for (AppUserTestEntity user : this.userMap.values()) {
            if (!email.equals(user.getEmail())) continue;
            return Optional.of(user.clone());
        }
        return Optional.empty();
    }

    public Page findAll(Pageable pageable) {
        return new PageImpl(new ArrayList<AppUserTestEntity>(this.userMap.values()), pageable, (long)this.userMap.size());
    }

    public Page<AppUserTestEntity> findAll(QueryAppUser query, Pageable pageable) {
        return new PageImpl(new ArrayList<AppUserTestEntity>(this.userMap.values()), pageable, (long)this.userMap.size());
    }

    public AppUserTestEntity save(AppUserTestEntity entity) {
        this.userMap.put(entity.getUsername(), entity);
        return this.userMap.get(entity.getUsername());
    }

    public Optional<AppUserTestEntity> findById(String id) {
        for (AppUserTestEntity user : this.userMap.values()) {
            if (!id.equals(user.getId())) continue;
            return Optional.of(user.clone());
        }
        return Optional.empty();
    }

    public long count() {
        return this.userMap.size();
    }

    public void delete(AppUserTestEntity entity) {
        this.userMap.remove(entity.getUsername());
    }

    public void deleteAll() {
    }

    public AppUserTestEntity initNewInstance() {
        return AppUserTestEntity.builder().id(UUID.randomUUID().toString()).created(Instant.now()).roles(new ArrayList<String>()).build();
    }
}

