/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.controller;

import io.rocketbase.commons.config.AuthProperties;
import io.rocketbase.commons.config.FormsProperties;
import io.rocketbase.commons.config.RegistrationProperties;
import io.rocketbase.commons.controller.AbstractFormsController;
import io.rocketbase.commons.dto.ErrorResponse;
import io.rocketbase.commons.dto.appuser.AppUserRead;
import io.rocketbase.commons.dto.registration.RegistrationRequest;
import io.rocketbase.commons.exception.BadRequestException;
import io.rocketbase.commons.resource.RegistrationResource;
import io.rocketbase.commons.util.UrlParts;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RegistrationFormsController
extends AbstractFormsController {
    private static final Logger log = LoggerFactory.getLogger(RegistrationFormsController.class);
    private final RegistrationResource registrationResource;
    @Value(value="${auth.forms.prefix:}")
    private String formsPrefix;

    public RegistrationFormsController(AuthProperties authProperties, FormsProperties formsProperties, RegistrationProperties registrationProperties) {
        super(authProperties, formsProperties, registrationProperties);
        this.registrationResource = new RegistrationResource(authProperties.getBaseUrl());
    }

    @GetMapping(value={"${auth.forms.prefix:}/registration"})
    public String registration(Model model) {
        model.addAttribute("registrationForm", (Object)new RegistrationForm());
        return "registration";
    }

    @PostMapping(value={"${auth.forms.prefix:}/registration"})
    public String registrationSubmit(@ModelAttribute(value="registrationForm") @Validated RegistrationForm registration, BindingResult bindingResult, Model model, HttpServletRequest request) {
        if (!bindingResult.hasErrors()) {
            if (!registration.getPassword().equals(registration.getPasswordRepeat())) {
                model.addAttribute("passwordErrors", (Object)"password not the same!");
            } else {
                try {
                    RegistrationRequest registrationRequest = registration.toRequest();
                    String verificationUrl = UrlParts.getBaseUrl((HttpServletRequest)request) + UrlParts.ensureStartsAndEndsWithSlash((String)this.formsPrefix) + "verification";
                    registrationRequest.setVerificationUrl(verificationUrl);
                    AppUserRead user = this.registrationResource.register(registrationRequest);
                    model.addAttribute("needsVerification", (Object)(!user.isEnabled() ? 1 : 0));
                    model.addAttribute("expiresAfter", (Object)this.getRegistrationProperties().getVerificationExpiration());
                    return "registration-success";
                }
                catch (BadRequestException badRequest) {
                    ErrorResponse errorResponse = badRequest.getErrorResponse();
                    if (errorResponse.hasField("username")) {
                        model.addAttribute("usernameErrors", errorResponse.getFields().get("username"));
                    }
                    if (errorResponse.hasField("email")) {
                        model.addAttribute("emailErrors", errorResponse.getFields().get("email"));
                    }
                    if (errorResponse.hasField("password")) {
                        model.addAttribute("passwordErrors", errorResponse.getFields().get("password"));
                    }
                }
                catch (Exception e) {
                    log.error("problem with the registration flow. {}", (Object)e.getMessage());
                }
            }
        }
        registration.setPassword("");
        registration.setPasswordRepeat("");
        return "registration";
    }

    @GetMapping(value={"${auth.forms.prefix:}/verification"})
    public String verification(@RequestParam(value="verification", required=false) String verification, Model model) {
        try {
            this.registrationResource.verify(verification);
            model.addAttribute("successfull", (Object)true);
        }
        catch (Exception e) {
            model.addAttribute("successfull", (Object)false);
        }
        return "registration-verification";
    }

    public static class RegistrationForm
    implements Serializable {
        @NotEmpty
        private String username;
        private String firstName;
        private String lastName;
        @NotEmpty
        @Email
        private String email;
        @NotEmpty
        private String password;
        private String passwordRepeat;

        public RegistrationRequest toRequest() {
            return RegistrationRequest.builder().username(this.username).firstName(this.firstName).lastName(this.lastName).email(this.email).password(this.password).build();
        }

        public static RegistrationFormBuilder builder() {
            return new RegistrationFormBuilder();
        }

        public String getUsername() {
            return this.username;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getEmail() {
            return this.email;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPasswordRepeat() {
            return this.passwordRepeat;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPasswordRepeat(String passwordRepeat) {
            this.passwordRepeat = passwordRepeat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegistrationForm)) {
                return false;
            }
            RegistrationForm other = (RegistrationForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$passwordRepeat = this.getPasswordRepeat();
            String other$passwordRepeat = other.getPasswordRepeat();
            return !(this$passwordRepeat == null ? other$passwordRepeat != null : !this$passwordRepeat.equals(other$passwordRepeat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RegistrationForm;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $passwordRepeat = this.getPasswordRepeat();
            result = result * 59 + ($passwordRepeat == null ? 43 : $passwordRepeat.hashCode());
            return result;
        }

        public RegistrationForm() {
        }

        public RegistrationForm(String username, String firstName, String lastName, String email, String password, String passwordRepeat) {
            this.username = username;
            this.firstName = firstName;
            this.lastName = lastName;
            this.email = email;
            this.password = password;
            this.passwordRepeat = passwordRepeat;
        }

        public String toString() {
            return "RegistrationFormsController.RegistrationForm(username=" + this.getUsername() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ")";
        }

        public static class RegistrationFormBuilder {
            private String username;
            private String firstName;
            private String lastName;
            private String email;
            private String password;
            private String passwordRepeat;

            RegistrationFormBuilder() {
            }

            public RegistrationFormBuilder username(String username) {
                this.username = username;
                return this;
            }

            public RegistrationFormBuilder firstName(String firstName) {
                this.firstName = firstName;
                return this;
            }

            public RegistrationFormBuilder lastName(String lastName) {
                this.lastName = lastName;
                return this;
            }

            public RegistrationFormBuilder email(String email) {
                this.email = email;
                return this;
            }

            public RegistrationFormBuilder password(String password) {
                this.password = password;
                return this;
            }

            public RegistrationFormBuilder passwordRepeat(String passwordRepeat) {
                this.passwordRepeat = passwordRepeat;
                return this;
            }

            public RegistrationForm build() {
                return new RegistrationForm(this.username, this.firstName, this.lastName, this.email, this.password, this.passwordRepeat);
            }

            public String toString() {
                return "RegistrationFormsController.RegistrationForm.RegistrationFormBuilder(username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", password=" + this.password + ", passwordRepeat=" + this.passwordRepeat + ")";
            }
        }
    }
}

