/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.controller;

import io.rocketbase.commons.config.AuthProperties;
import io.rocketbase.commons.config.FormsProperties;
import io.rocketbase.commons.config.RegistrationProperties;
import io.rocketbase.commons.controller.AbstractFormsController;
import io.rocketbase.commons.dto.appinvite.AppInviteRead;
import io.rocketbase.commons.dto.appinvite.ConfirmInviteRequest;
import io.rocketbase.commons.exception.BadRequestException;
import io.rocketbase.commons.resource.InviteResource;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class InviteFormsController
extends AbstractFormsController {
    private static final Logger log = LoggerFactory.getLogger(InviteFormsController.class);
    private final InviteResource inviteResource;
    @Value(value="${auth.forms.prefix:}")
    private String formsPrefix;

    public InviteFormsController(AuthProperties authProperties, FormsProperties formsProperties, RegistrationProperties registrationProperties) {
        super(authProperties, formsProperties, registrationProperties);
        this.inviteResource = new InviteResource(authProperties.getBaseUrl());
    }

    @GetMapping(value={"${auth.forms.prefix:}/invite"})
    public String verify(@RequestParam(value="inviteId", required=false) String inviteId, Model model) {
        try {
            AppInviteRead info = this.inviteResource.verify(inviteId);
            model.addAttribute("validInvite", (Object)true);
            model.addAttribute("invitor", (Object)info.getInvitor());
            model.addAttribute("message", (Object)(StringUtils.isEmpty((Object)info.getMessage()) ? null : info.getMessage()));
            model.addAttribute("inviteForm", (Object)new InviteForm(info));
        }
        catch (Exception e) {
            model.addAttribute("validInvite", (Object)false);
            model.addAttribute("inviteForm", (Object)ConfirmInviteRequest.builder().inviteId(inviteId).build());
        }
        return "invite";
    }

    /*
     * Unable to fully structure code
     */
    @PostMapping(value={"${auth.forms.prefix:}/invite"})
    public String transformToUser(@ModelAttribute(value="inviteForm") @Validated InviteForm form, BindingResult bindingResult, Model model, HttpServletRequest request) {
        if (!bindingResult.hasErrors()) {
            if (!form.getPassword().equals(form.getPasswordRepeat())) {
                model.addAttribute("passwordErrors", (Object)"password not the same!");
            } else {
                model.addAttribute("validInvite", (Object)true);
                try {
                    confirmInviteRequest = form.toRequest();
                    user = this.inviteResource.transformToUser(confirmInviteRequest);
                    model.addAttribute("username", (Object)user.getUsername());
                    return "invite-success";
                }
                catch (BadRequestException badRequest) {
                    errorResponse = badRequest.getErrorResponse();
                    if (errorResponse.hasField("username")) {
                        model.addAttribute("usernameErrors", errorResponse.getFields().get("username"));
                    }
                    if (errorResponse.hasField("email")) {
                        model.addAttribute("emailErrors", errorResponse.getFields().get("email"));
                    }
                    if (!errorResponse.hasField("password")) ** GOTO lbl40
                    model.addAttribute("passwordErrors", errorResponse.getFields().get("password"));
                }
                catch (Exception e) {
                    model.addAttribute("validInvite", (Object)false);
                    InviteFormsController.log.error("problem with the invite flow. {}", (Object)e.getMessage());
                }
            }
        } else {
            try {
                this.inviteResource.verify(form.getInviteId());
                model.addAttribute("validInvite", (Object)true);
            }
            catch (Exception e) {
                model.addAttribute("validInvite", (Object)false);
            }
        }
lbl40:
        // 6 sources

        form.setPassword("");
        form.setPasswordRepeat("");
        model.addAttribute("invitor", (Object)form.getInvitor());
        model.addAttribute("message", (Object)form.getMessage());
        return "invite";
    }

    public static class InviteForm
    implements Serializable {
        @NotNull
        private String inviteId;
        private String invitor;
        private String message;
        @NotEmpty
        private String username;
        private String firstName;
        private String lastName;
        @NotEmpty
        @Email
        private String email;
        @NotEmpty
        private String password;
        private String passwordRepeat;

        public InviteForm(AppInviteRead read) {
            this.setInviteId(read.getId());
            this.setInvitor(read.getInvitor());
            this.setMessage(read.getMessage());
            this.setFirstName(read.getFirstName());
            this.setLastName(read.getLastName());
            this.setEmail(read.getEmail());
        }

        public ConfirmInviteRequest toRequest() {
            return ConfirmInviteRequest.builder().inviteId(this.inviteId).username(this.username).email(this.email).firstName(this.firstName).lastName(this.lastName).password(this.password).build();
        }

        public static InviteFormBuilder builder() {
            return new InviteFormBuilder();
        }

        public String getInviteId() {
            return this.inviteId;
        }

        public String getInvitor() {
            return this.invitor;
        }

        public String getMessage() {
            return this.message;
        }

        public String getUsername() {
            return this.username;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getEmail() {
            return this.email;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPasswordRepeat() {
            return this.passwordRepeat;
        }

        public void setInviteId(String inviteId) {
            this.inviteId = inviteId;
        }

        public void setInvitor(String invitor) {
            this.invitor = invitor;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPasswordRepeat(String passwordRepeat) {
            this.passwordRepeat = passwordRepeat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InviteForm)) {
                return false;
            }
            InviteForm other = (InviteForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$inviteId = this.getInviteId();
            String other$inviteId = other.getInviteId();
            if (this$inviteId == null ? other$inviteId != null : !this$inviteId.equals(other$inviteId)) {
                return false;
            }
            String this$invitor = this.getInvitor();
            String other$invitor = other.getInvitor();
            if (this$invitor == null ? other$invitor != null : !this$invitor.equals(other$invitor)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$passwordRepeat = this.getPasswordRepeat();
            String other$passwordRepeat = other.getPasswordRepeat();
            return !(this$passwordRepeat == null ? other$passwordRepeat != null : !this$passwordRepeat.equals(other$passwordRepeat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InviteForm;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $inviteId = this.getInviteId();
            result = result * 59 + ($inviteId == null ? 43 : $inviteId.hashCode());
            String $invitor = this.getInvitor();
            result = result * 59 + ($invitor == null ? 43 : $invitor.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $passwordRepeat = this.getPasswordRepeat();
            result = result * 59 + ($passwordRepeat == null ? 43 : $passwordRepeat.hashCode());
            return result;
        }

        public InviteForm() {
        }

        public InviteForm(String inviteId, String invitor, String message, String username, String firstName, String lastName, String email, String password, String passwordRepeat) {
            this.inviteId = inviteId;
            this.invitor = invitor;
            this.message = message;
            this.username = username;
            this.firstName = firstName;
            this.lastName = lastName;
            this.email = email;
            this.password = password;
            this.passwordRepeat = passwordRepeat;
        }

        public String toString() {
            return "InviteFormsController.InviteForm(inviteId=" + this.getInviteId() + ", invitor=" + this.getInvitor() + ", message=" + this.getMessage() + ", username=" + this.getUsername() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ")";
        }

        public static class InviteFormBuilder {
            private String inviteId;
            private String invitor;
            private String message;
            private String username;
            private String firstName;
            private String lastName;
            private String email;
            private String password;
            private String passwordRepeat;

            InviteFormBuilder() {
            }

            public InviteFormBuilder inviteId(String inviteId) {
                this.inviteId = inviteId;
                return this;
            }

            public InviteFormBuilder invitor(String invitor) {
                this.invitor = invitor;
                return this;
            }

            public InviteFormBuilder message(String message) {
                this.message = message;
                return this;
            }

            public InviteFormBuilder username(String username) {
                this.username = username;
                return this;
            }

            public InviteFormBuilder firstName(String firstName) {
                this.firstName = firstName;
                return this;
            }

            public InviteFormBuilder lastName(String lastName) {
                this.lastName = lastName;
                return this;
            }

            public InviteFormBuilder email(String email) {
                this.email = email;
                return this;
            }

            public InviteFormBuilder password(String password) {
                this.password = password;
                return this;
            }

            public InviteFormBuilder passwordRepeat(String passwordRepeat) {
                this.passwordRepeat = passwordRepeat;
                return this;
            }

            public InviteForm build() {
                return new InviteForm(this.inviteId, this.invitor, this.message, this.username, this.firstName, this.lastName, this.email, this.password, this.passwordRepeat);
            }

            public String toString() {
                return "InviteFormsController.InviteForm.InviteFormBuilder(inviteId=" + this.inviteId + ", invitor=" + this.invitor + ", message=" + this.message + ", username=" + this.username + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", password=" + this.password + ", passwordRepeat=" + this.passwordRepeat + ")";
            }
        }
    }
}

