/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.controller;

import io.rocketbase.commons.config.AuthProperties;
import io.rocketbase.commons.config.FormsProperties;
import io.rocketbase.commons.config.RegistrationProperties;
import io.rocketbase.commons.controller.AbstractFormsController;
import io.rocketbase.commons.dto.forgot.ForgotPasswordRequest;
import io.rocketbase.commons.dto.forgot.PerformPasswordResetRequest;
import io.rocketbase.commons.exception.BadRequestException;
import io.rocketbase.commons.resource.ForgotPasswordResource;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AuthFormsController
extends AbstractFormsController {
    private static final Logger log = LoggerFactory.getLogger(AuthFormsController.class);
    private final AuthProperties authProperties;
    private final ForgotPasswordResource forgotPasswordResource;

    public AuthFormsController(String apiBaseUrl, FormsProperties formsProperties, RegistrationProperties registrationProperties, AuthProperties authProperties) {
        super(apiBaseUrl, formsProperties, registrationProperties);
        this.authProperties = authProperties;
        this.forgotPasswordResource = new ForgotPasswordResource(apiBaseUrl);
    }

    @GetMapping(value={"/login"})
    public String loginForm() {
        return "login";
    }

    @GetMapping(value={"/logout"})
    public String logoutForm(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        return "redirect:/login?logout";
    }

    @GetMapping(value={"/forgot"})
    public String forgotForm(Model model) {
        model.addAttribute("forgotForm", (Object)new ForgotPasswordRequest());
        return "forgot";
    }

    @PostMapping(value={"/forgot"})
    public String forgotSubmit(@ModelAttribute(value="forgotForm") @Validated ForgotPasswordRequest forgot, BindingResult bindingResult, Model model) {
        if (!bindingResult.hasErrors()) {
            if (StringUtils.isEmpty((Object)forgot.getEmail()) && StringUtils.isEmpty((Object)forgot.getUsername())) {
                model.addAttribute("usernameOrEmailRequired", (Object)true);
            } else {
                try {
                    this.forgotPasswordResource.forgotPassword(forgot);
                    model.addAttribute("expiresAfter", (Object)this.authProperties.getPasswordResetExpiration());
                    return "forgot-submitted";
                }
                catch (BadRequestException badRequest) {
                    model.addAttribute("serviceException", (Object)badRequest.getErrorResponse().getMessage());
                }
                catch (Exception e) {
                    log.error("forgot password request - unexpected service exception: {}", (Object)e.getMessage());
                    model.addAttribute("serviceException", (Object)"unexpected service exception");
                }
            }
        }
        return "forgot";
    }

    @GetMapping(value={"/reset-password"})
    public String resetPasswordForm(@RequestParam(value="verification", required=false) String verification, Model model) {
        model.addAttribute("resetPasswordForm", (Object)ResetPasswordForm.builder().verification(verification).build());
        try {
            this.getValidationResource().validateToken(verification);
            model.addAttribute("verificationValid", (Object)true);
        }
        catch (Exception e) {
            model.addAttribute("verificationValid", (Object)false);
        }
        return "reset-password";
    }

    @PostMapping(value={"/reset-password"})
    public String resetPasswordSubmit(@ModelAttribute(value="resetPasswordForm") @Validated ResetPasswordForm resetPassword, BindingResult bindingResult, Model model) {
        if (!bindingResult.hasErrors()) {
            if (!resetPassword.getPassword().equals(resetPassword.getPasswordRepeat())) {
                model.addAttribute("passwordErrors", (Object)"password not the same!");
            } else {
                try {
                    this.forgotPasswordResource.resetPassword(resetPassword.toRequest());
                    return "reset-password-success";
                }
                catch (BadRequestException badRequest) {
                    Map fields = badRequest.getErrorResponse().getFields();
                    if (fields.containsKey("password")) {
                        model.addAttribute("passwordErrors", fields.get("password"));
                    }
                }
                catch (Exception e) {
                    log.error("problem with the password-reset flow. {}", (Object)e.getMessage());
                }
            }
        }
        return "reset-password";
    }

    public static class ResetPasswordForm
    implements Serializable {
        private String verification;
        @NotEmpty
        private String password;
        @NotEmpty
        private String passwordRepeat;

        public PerformPasswordResetRequest toRequest() {
            return PerformPasswordResetRequest.builder().verification(this.verification).password(this.password).build();
        }

        public static ResetPasswordFormBuilder builder() {
            return new ResetPasswordFormBuilder();
        }

        public String getVerification() {
            return this.verification;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPasswordRepeat() {
            return this.passwordRepeat;
        }

        public void setVerification(String verification) {
            this.verification = verification;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPasswordRepeat(String passwordRepeat) {
            this.passwordRepeat = passwordRepeat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResetPasswordForm)) {
                return false;
            }
            ResetPasswordForm other = (ResetPasswordForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$verification = this.getVerification();
            String other$verification = other.getVerification();
            if (this$verification == null ? other$verification != null : !this$verification.equals(other$verification)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$passwordRepeat = this.getPasswordRepeat();
            String other$passwordRepeat = other.getPasswordRepeat();
            return !(this$passwordRepeat == null ? other$passwordRepeat != null : !this$passwordRepeat.equals(other$passwordRepeat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResetPasswordForm;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $verification = this.getVerification();
            result = result * 59 + ($verification == null ? 43 : $verification.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $passwordRepeat = this.getPasswordRepeat();
            result = result * 59 + ($passwordRepeat == null ? 43 : $passwordRepeat.hashCode());
            return result;
        }

        public ResetPasswordForm() {
        }

        public ResetPasswordForm(String verification, String password, String passwordRepeat) {
            this.verification = verification;
            this.password = password;
            this.passwordRepeat = passwordRepeat;
        }

        public String toString() {
            return "AuthFormsController.ResetPasswordForm(verification=" + this.getVerification() + ")";
        }

        public static class ResetPasswordFormBuilder {
            private String verification;
            private String password;
            private String passwordRepeat;

            ResetPasswordFormBuilder() {
            }

            public ResetPasswordFormBuilder verification(String verification) {
                this.verification = verification;
                return this;
            }

            public ResetPasswordFormBuilder password(String password) {
                this.password = password;
                return this;
            }

            public ResetPasswordFormBuilder passwordRepeat(String passwordRepeat) {
                this.passwordRepeat = passwordRepeat;
                return this;
            }

            public ResetPasswordForm build() {
                return new ResetPasswordForm(this.verification, this.password, this.passwordRepeat);
            }

            public String toString() {
                return "AuthFormsController.ResetPasswordForm.ResetPasswordFormBuilder(verification=" + this.verification + ", password=" + this.password + ", passwordRepeat=" + this.passwordRepeat + ")";
            }
        }
    }
}

