/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.controller;

import io.rocketbase.commons.config.FormsProperties;
import io.rocketbase.commons.config.RegistrationProperties;
import io.rocketbase.commons.resource.ValidationResource;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class AbstractFormsController {
    private final String apiBaseUrl;
    private final FormsProperties formsProperties;
    private final RegistrationProperties registrationProperties;
    private ValidationResource validationResource;

    public AbstractFormsController(String apiBaseUrl, FormsProperties formsProperties, RegistrationProperties registrationProperties) {
        this.apiBaseUrl = apiBaseUrl;
        this.formsProperties = formsProperties;
        this.registrationProperties = registrationProperties;
        this.validationResource = new ValidationResource(apiBaseUrl);
    }

    @ModelAttribute
    public void populateDefaults(Model model) {
        model.addAttribute("title", (Object)this.formsProperties.getTitle());
        model.addAttribute("logoSrc", (Object)this.formsProperties.getLogoSrc());
        model.addAttribute("registrationEnabled", (Object)this.registrationProperties.isEnabled());
    }

    public FormsProperties getFormsProperties() {
        return this.formsProperties;
    }

    public RegistrationProperties getRegistrationProperties() {
        return this.registrationProperties;
    }

    public ValidationResource getValidationResource() {
        return this.validationResource;
    }
}

