/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.config;

import io.rocketbase.commons.config.AuthProperties;
import io.rocketbase.commons.config.FormsProperties;
import io.rocketbase.commons.config.RegistrationProperties;
import io.rocketbase.commons.controller.AuthFormsController;
import io.rocketbase.commons.controller.RegistrationFormsController;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={AuthProperties.class, FormsProperties.class, RegistrationProperties.class})
public class AuthFormAutoConfiguration {
    private final AuthProperties authProperties;
    private final FormsProperties formsProperties;
    private final RegistrationProperties registrationProperties;

    @Bean
    @ConditionalOnMissingBean
    public AuthFormsController authFormsController(@Value(value="${auth.api.baseUrl}") String apiBaseUrl) {
        return new AuthFormsController(apiBaseUrl, this.formsProperties, this.registrationProperties, this.authProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"auth.registration.enabled"}, matchIfMissing=true)
    public RegistrationFormsController registrationFormsController(@Value(value="${auth.api.baseUrl}") String apiBaseUrl) {
        return new RegistrationFormsController(apiBaseUrl, this.formsProperties, this.registrationProperties);
    }

    public AuthFormAutoConfiguration(AuthProperties authProperties, FormsProperties formsProperties, RegistrationProperties registrationProperties) {
        this.authProperties = authProperties;
        this.formsProperties = formsProperties;
        this.registrationProperties = registrationProperties;
    }
}

