/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.service.user;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.rocketbase.commons.config.JwtProperties;
import io.rocketbase.commons.event.ActiveUserChangedEvent;
import io.rocketbase.commons.model.AppUserToken;
import io.rocketbase.commons.service.user.ActiveUserStore;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ActiveUserStoreLocalCache
implements ActiveUserStore {
    protected final Cache<String, Boolean> activeUsers;
    @Resource
    protected ApplicationEventPublisher applicationEventPublisher;

    public ActiveUserStoreLocalCache(JwtProperties jwtProperties) {
        this.activeUsers = CacheBuilder.newBuilder().expireAfterWrite(jwtProperties.getAccessTokenExpiration(), TimeUnit.MINUTES).removalListener(l -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new ActiveUserChangedEvent(this))).build();
    }

    protected ActiveUserStoreLocalCache(long millisToExpire) {
        this.activeUsers = CacheBuilder.newBuilder().expireAfterWrite(millisToExpire, TimeUnit.MILLISECONDS).removalListener(l -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new ActiveUserChangedEvent(this))).build();
    }

    @Override
    public void addUser(AppUserToken user) {
        boolean isPresent = this.activeUsers.getIfPresent((Object)user.getId()) != null;
        this.activeUsers.put((Object)user.getId(), (Object)true);
        if (!isPresent) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ActiveUserChangedEvent(this));
        }
    }

    @Override
    public void clear() {
        this.activeUsers.invalidateAll();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ActiveUserChangedEvent(this));
    }

    @Override
    public long getUserCount() {
        this.activeUsers.cleanUp();
        return this.activeUsers.size();
    }

    @Override
    public Set<String> getUserIds() {
        this.activeUsers.cleanUp();
        return this.activeUsers.asMap().keySet();
    }
}

