/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.service;

import io.rocketbase.commons.config.AuthProperties;
import lombok.Generated;
import org.springframework.util.StringUtils;

public interface FeedbackActionService {
    public AuthProperties getAuthProperties();

    default public String buildActionUrl(String applicationBaseUrl, ActionType actionType, String token, String customUrl) {
        Object result = StringUtils.isEmpty((Object)customUrl) ? this.buildBaseUrl(applicationBaseUrl, actionType) : customUrl;
        result = (String)result + (((String)result).contains("?") ? "&" : "?");
        result = (String)result + actionType.getParameterName() + "=" + token;
        return result;
    }

    default public String buildBaseUrl(String applicationBaseUrl, ActionType actionType) {
        Object result;
        String configuredUrl = null;
        switch (actionType) {
            case VERIFICATION_REGISTRATION: {
                configuredUrl = this.getAuthProperties().getVerificationUrl();
                break;
            }
            case PASSWORD_RESET: {
                configuredUrl = this.getAuthProperties().getPasswordResetUrl();
                break;
            }
            case INVITE: {
                configuredUrl = this.getAuthProperties().getInviteUrl();
                break;
            }
            case CHANGE_EMAIL: {
                configuredUrl = this.getAuthProperties().getChangeEmailUrl();
                break;
            }
            case CHANGE_USERNAME: {
                configuredUrl = this.getAuthProperties().getChangeUsernameUrl();
            }
        }
        if (!StringUtils.isEmpty(configuredUrl)) {
            result = configuredUrl;
        } else {
            result = applicationBaseUrl;
            if (((String)result).endsWith("/")) {
                result = ((String)result).substring(0, ((String)result).length() - 1);
            }
            result = (String)result + actionType.getApiPath();
        }
        return result;
    }

    public static enum ActionType {
        VERIFICATION_REGISTRATION("/verification", "verification"),
        PASSWORD_RESET("/reset-password", "verification"),
        INVITE("/invite", "inviteId"),
        CHANGE_EMAIL("/change-email", "verification"),
        CHANGE_USERNAME("/change-username", "verification");

        private final String apiPath;
        private final String parameterName;

        private ActionType(String apiPath, String parameterName) {
            this.apiPath = apiPath;
            this.parameterName = parameterName;
        }

        @Generated
        public String getApiPath() {
            return this.apiPath;
        }

        @Generated
        public String getParameterName() {
            return this.parameterName;
        }
    }
}

