/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.rocketbase.commons.config.JwtProperties;
import io.rocketbase.commons.converter.AppUserConverter;
import io.rocketbase.commons.dto.authentication.JwtTokenBundle;
import io.rocketbase.commons.model.AppUserEntity;
import io.rocketbase.commons.model.AppUserToken;
import io.rocketbase.commons.model.SimpleAppUserToken;
import io.rocketbase.commons.security.CustomAuthoritiesProvider;
import io.rocketbase.commons.util.RolesAuthoritiesConverter;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class JwtTokenService
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtTokenService.class);
    public static final String REFRESH_TOKEN = "REFRESH_TOKEN";
    public static final String ROLES_KEY = "scopes";
    public static final String USER_ID_KEY = "user_id";
    public static final String FIRST_NAME_KEY = "given_name";
    public static final String LAST_NAME_KEY = "family_name";
    public static final String EMAIL_KEY = "email";
    public static final String AVATAR_KEY = "picture";
    public static final String KEY_VALUE_PREFIX = "kv_";
    final JwtProperties jwtProperties;
    final CustomAuthoritiesProvider customAuthoritiesProvider;

    public String getUsernameFromToken(String token) {
        return this.getClaimFromToken(token, Claims::getSubject);
    }

    public Collection<GrantedAuthority> getAuthoritiesFromToken(String token) {
        Claims claims = this.getAllClaimsFromToken(token);
        List roles = (List)claims.getOrDefault((Object)ROLES_KEY, Collections.emptyList());
        ArrayList<GrantedAuthority> result = new ArrayList<GrantedAuthority>();
        for (Object r : roles) {
            result.add((GrantedAuthority)new SimpleGrantedAuthority(String.valueOf(r)));
        }
        return result;
    }

    public Instant getIssuedAtDateFromToken(String token) {
        Date issuedAt = this.getClaimFromToken(token, Claims::getIssuedAt);
        return Instant.ofEpochMilli(issuedAt.getTime());
    }

    public Instant getExpirationDateFromToken(String token) {
        Date expiration = this.getClaimFromToken(token, Claims::getExpiration);
        return Instant.ofEpochMilli(expiration.getTime());
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

    private Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.jwtProperties.getSecret()).build().parseClaimsJws((CharSequence)token).getBody();
    }

    public AppUserToken parseToken(String token) {
        Claims claims = this.getAllClaimsFromToken(token);
        HashMap<String, String> keyValues = null;
        for (String key : claims.keySet()) {
            if (!key.startsWith(KEY_VALUE_PREFIX)) continue;
            if (keyValues == null) {
                keyValues = new HashMap<String, String>();
            }
            keyValues.put(key.replaceAll("^kv_", ""), (String)claims.get(key, String.class));
        }
        return SimpleAppUserToken.builder().id((String)claims.get(USER_ID_KEY, String.class)).username(claims.getSubject()).firstName((String)claims.get(FIRST_NAME_KEY, String.class)).lastName((String)claims.get(LAST_NAME_KEY, String.class)).email((String)claims.get(EMAIL_KEY, String.class)).avatar((String)claims.get(AVATAR_KEY, String.class)).roles((List)claims.getOrDefault((Object)ROLES_KEY, Collections.emptyList())).keyValueMap(keyValues).build();
    }

    public JwtTokenBundle generateTokenBundle(AppUserToken appUserToken) {
        Instant now = Instant.now();
        return new JwtTokenBundle(this.generateAccessToken(now, appUserToken), this.prepareBuilder(now, this.jwtProperties.getRefreshTokenExpiration(), appUserToken.getUsername()).claim(USER_ID_KEY, (Object)appUserToken.getId()).claim(ROLES_KEY, Arrays.asList(REFRESH_TOKEN)).compact());
    }

    public String generateAccessToken(AppUserToken appUserToken) {
        return this.generateAccessToken(Instant.now(), appUserToken);
    }

    protected String generateAccessToken(Instant ldt, AppUserToken appUserToken) {
        ArrayList<Object> scopes = new ArrayList<Object>();
        scopes.addAll(RolesAuthoritiesConverter.convert(appUserToken.getRoles()));
        scopes.addAll(this.customAuthoritiesProvider.getExtraTokenAuthorities(appUserToken));
        JwtBuilder jwtBuilder = this.prepareBuilder(ldt, this.jwtProperties.getAccessTokenExpiration(), appUserToken.getUsername()).claim(ROLES_KEY, RolesAuthoritiesConverter.convertToDtos(scopes)).claim(USER_ID_KEY, (Object)appUserToken.getId()).claim(FIRST_NAME_KEY, (Object)appUserToken.getFirstName()).claim(LAST_NAME_KEY, (Object)appUserToken.getLastName()).claim(EMAIL_KEY, (Object)appUserToken.getEmail()).claim(AVATAR_KEY, (Object)appUserToken.getAvatar());
        Map<String, String> keyValues = AppUserConverter.filterInvisibleKeys(appUserToken.getKeyValues());
        if (keyValues != null) {
            for (Map.Entry<String, String> entry : keyValues.entrySet()) {
                if (entry.getKey().startsWith("#")) continue;
                jwtBuilder.claim(KEY_VALUE_PREFIX + entry.getKey(), (Object)entry.getValue());
            }
        }
        return jwtBuilder.compact();
    }

    private JwtBuilder prepareBuilder(Instant ldt, long expirationMinutes, String username) {
        return (JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setIssuedAt(this.convert(ldt))).setExpiration(this.convert(ldt.plusSeconds(expirationMinutes * 60L)))).signWith(SignatureAlgorithm.HS512, this.jwtProperties.getSecret()).setSubject(username);
    }

    private Date convert(Instant ldt) {
        return Date.from(ldt.atZone(ZoneOffset.UTC).toInstant());
    }

    public Boolean validateToken(String token, String username, Instant lastTokenInvalidation) {
        try {
            this.getAllClaimsFromToken(token);
        }
        catch (JwtException e) {
            if (log.isTraceEnabled()) {
                log.trace("token is invalid", (Throwable)e);
            }
            return false;
        }
        if (!this.getUsernameFromToken(token).equals(username)) {
            if (log.isTraceEnabled()) {
                log.trace("token username differs");
            }
            return false;
        }
        if (lastTokenInvalidation == null) {
            return true;
        }
        boolean validIssued = lastTokenInvalidation.isBefore(this.getIssuedAtDateFromToken(token));
        if (log.isTraceEnabled() && !validIssued) {
            log.trace("token is issued {} before lastTokenInvalidation {}", (Object)this.getIssuedAtDateFromToken(token), (Object)lastTokenInvalidation);
        }
        return validIssued;
    }

    public Boolean validateToken(String token, AppUserEntity user) {
        return this.validateToken(token, user.getUsername(), user.getLastTokenInvalidation());
    }

    @Generated
    public JwtTokenService(JwtProperties jwtProperties, CustomAuthoritiesProvider customAuthoritiesProvider) {
        this.jwtProperties = jwtProperties;
        this.customAuthoritiesProvider = customAuthoritiesProvider;
    }
}

