/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.model;

import io.rocketbase.commons.model.HasKeyValue;
import org.springframework.util.Assert;

public interface EntityWithKeyValue<T>
extends HasKeyValue {
    default public T addKeyValue(String key, String value) {
        this.checkKeyValue(key, value);
        this.getKeyValues().put(key, value);
        return (T)this;
    }

    default public void removeKeyValue(String key) {
        this.getKeyValues().remove(key);
    }

    default public void checkKeyValue(String key, String value) {
        Assert.hasLength((String)key, (String)"Key must not be empty");
        Assert.state((key.length() <= 50 ? 1 : 0) != 0, (String)"Key is too long - at least 50 chars");
        Assert.state((boolean)key.matches("[a-zA-Z0-9_\\-\\.\\#]+"), (String)"Allowed key chars are a-Z, 0-9 and _-.#");
    }
}

