/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.rocketbase.commons.model.AppUserReference;
import io.rocketbase.commons.model.AppUserToken;
import io.rocketbase.commons.model.EntityWithKeyValue;
import io.rocketbase.commons.model.SimpleAppUserReference;
import java.time.Instant;
import java.util.List;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import org.springframework.security.core.userdetails.UserDetails;

public interface AppUserEntity
extends UserDetails,
AppUserToken,
EntityWithKeyValue<AppUserEntity> {
    public void setId(String var1);

    public void setUsername(@NotNull String var1);

    public String getPassword();

    public void setPassword(@NotNull String var1);

    public void setFirstName(String var1);

    public void setLastName(String var1);

    public void setEmail(@NotNull @Email String var1);

    public void setAvatar(String var1);

    public void setRoles(List<String> var1);

    public void setEnabled(boolean var1);

    public Instant getCreated();

    public Instant getLastLogin();

    public void updateLastLogin();

    public Instant getLastTokenInvalidation();

    public void updateLastTokenInvalidation();

    @JsonIgnore
    default public AppUserReference toReference() {
        return SimpleAppUserReference.builder().id(this.getId()).username(this.getUsername()).firstName(this.getFirstName()).lastName(this.getLastName()).email(this.getEmail()).avatar(this.getAvatar()).build();
    }

    @JsonIgnore
    default public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    default public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    default public boolean isCredentialsNonExpired() {
        return true;
    }
}

