/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.config;

import io.rocketbase.commons.util.UrlParts;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="auth")
public class AuthProperties {
    @NotEmpty
    private String roleAdmin = "ADMIN";
    @NotEmpty
    private String roleUser = "USER";
    @NotEmpty
    private String tokenSecret = "E*iqzFiW#kSmAo8rO^V8%DRlQ#1f&B$i";
    private int userCacheTime = 30;
    private String baseUrl = "http://localhost:8080";
    private String prefix = "";
    private boolean verifyEmail = true;
    private String verificationUrl = null;
    private String passwordResetUrl = null;
    private String inviteUrl = null;
    private String changeEmailUrl = null;
    private String changeUsernameUrl = null;
    private long passwordResetExpiration = 60L;
    private long changeEmailExpiration = 60L;
    private long changeUsernameExpiration = 60L;
    private long inviteExpiration = 10080L;

    public String getOauthRestEndpointPaths() {
        return UrlParts.ensureStartsAndEndsWithSlash((String)this.prefix) + "auth/oauth2/token";
    }

    public String[] getAllPublicRestEndpointPaths() {
        String prefixPath = UrlParts.ensureStartsAndEndsWithSlash((String)this.prefix);
        return new String[]{this.getOauthRestEndpointPaths(), prefixPath + "auth/login", prefixPath + "auth/forgot-password", prefixPath + "auth/reset-password", prefixPath + "auth/validate", prefixPath + "auth/validate/*", prefixPath + "auth/register", prefixPath + "auth/invite", prefixPath + "auth/verify", prefixPath + "auth/verify-email"};
    }

    public String[] getAllAuthenticatedRestEndpointPaths() {
        String prefixPath = UrlParts.ensureStartsAndEndsWithSlash((String)this.prefix);
        return new String[]{prefixPath + "auth/me", prefixPath + "auth/refresh", prefixPath + "auth/update-profile", prefixPath + "auth/change-password", prefixPath + "auth/change-username", prefixPath + "auth/change-email"};
    }

    public String[] getApiRestEndpointPaths() {
        String prefixPath = UrlParts.ensureStartsAndEndsWithSlash((String)this.prefix);
        return new String[]{prefixPath + "api/user", prefixPath + "api/user/*", prefixPath + "api/user/*/*"};
    }

    public String[] getApiInviteRestEndpointPaths() {
        String prefixPath = UrlParts.ensureStartsAndEndsWithSlash((String)this.prefix);
        return new String[]{prefixPath + "api/invite", prefixPath + "api/invite/*"};
    }

    public String[] getUserSearchRestEndpointPaths() {
        String prefixPath = UrlParts.ensureStartsAndEndsWithSlash((String)this.prefix);
        return new String[]{prefixPath + "api/user-search", prefixPath + "api/user-search/*"};
    }

    public String getImpersonateEndpointPaths() {
        return UrlParts.ensureStartsAndEndsWithSlash((String)this.prefix) + "api/impersonate/*";
    }

    @Generated
    public AuthProperties() {
    }

    @Generated
    public String getRoleAdmin() {
        return this.roleAdmin;
    }

    @Generated
    public String getRoleUser() {
        return this.roleUser;
    }

    @Generated
    public String getTokenSecret() {
        return this.tokenSecret;
    }

    @Generated
    public int getUserCacheTime() {
        return this.userCacheTime;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    @Generated
    public String getVerificationUrl() {
        return this.verificationUrl;
    }

    @Generated
    public String getPasswordResetUrl() {
        return this.passwordResetUrl;
    }

    @Generated
    public String getInviteUrl() {
        return this.inviteUrl;
    }

    @Generated
    public String getChangeEmailUrl() {
        return this.changeEmailUrl;
    }

    @Generated
    public String getChangeUsernameUrl() {
        return this.changeUsernameUrl;
    }

    @Generated
    public long getPasswordResetExpiration() {
        return this.passwordResetExpiration;
    }

    @Generated
    public long getChangeEmailExpiration() {
        return this.changeEmailExpiration;
    }

    @Generated
    public long getChangeUsernameExpiration() {
        return this.changeUsernameExpiration;
    }

    @Generated
    public long getInviteExpiration() {
        return this.inviteExpiration;
    }

    @Generated
    public void setRoleAdmin(String roleAdmin) {
        this.roleAdmin = roleAdmin;
    }

    @Generated
    public void setRoleUser(String roleUser) {
        this.roleUser = roleUser;
    }

    @Generated
    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    @Generated
    public void setUserCacheTime(int userCacheTime) {
        this.userCacheTime = userCacheTime;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setVerifyEmail(boolean verifyEmail) {
        this.verifyEmail = verifyEmail;
    }

    @Generated
    public void setVerificationUrl(String verificationUrl) {
        this.verificationUrl = verificationUrl;
    }

    @Generated
    public void setPasswordResetUrl(String passwordResetUrl) {
        this.passwordResetUrl = passwordResetUrl;
    }

    @Generated
    public void setInviteUrl(String inviteUrl) {
        this.inviteUrl = inviteUrl;
    }

    @Generated
    public void setChangeEmailUrl(String changeEmailUrl) {
        this.changeEmailUrl = changeEmailUrl;
    }

    @Generated
    public void setChangeUsernameUrl(String changeUsernameUrl) {
        this.changeUsernameUrl = changeUsernameUrl;
    }

    @Generated
    public void setPasswordResetExpiration(long passwordResetExpiration) {
        this.passwordResetExpiration = passwordResetExpiration;
    }

    @Generated
    public void setChangeEmailExpiration(long changeEmailExpiration) {
        this.changeEmailExpiration = changeEmailExpiration;
    }

    @Generated
    public void setChangeUsernameExpiration(long changeUsernameExpiration) {
        this.changeUsernameExpiration = changeUsernameExpiration;
    }

    @Generated
    public void setInviteExpiration(long inviteExpiration) {
        this.inviteExpiration = inviteExpiration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthProperties)) {
            return false;
        }
        AuthProperties other = (AuthProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUserCacheTime() != other.getUserCacheTime()) {
            return false;
        }
        if (this.isVerifyEmail() != other.isVerifyEmail()) {
            return false;
        }
        if (this.getPasswordResetExpiration() != other.getPasswordResetExpiration()) {
            return false;
        }
        if (this.getChangeEmailExpiration() != other.getChangeEmailExpiration()) {
            return false;
        }
        if (this.getChangeUsernameExpiration() != other.getChangeUsernameExpiration()) {
            return false;
        }
        if (this.getInviteExpiration() != other.getInviteExpiration()) {
            return false;
        }
        String this$roleAdmin = this.getRoleAdmin();
        String other$roleAdmin = other.getRoleAdmin();
        if (this$roleAdmin == null ? other$roleAdmin != null : !this$roleAdmin.equals(other$roleAdmin)) {
            return false;
        }
        String this$roleUser = this.getRoleUser();
        String other$roleUser = other.getRoleUser();
        if (this$roleUser == null ? other$roleUser != null : !this$roleUser.equals(other$roleUser)) {
            return false;
        }
        String this$tokenSecret = this.getTokenSecret();
        String other$tokenSecret = other.getTokenSecret();
        if (this$tokenSecret == null ? other$tokenSecret != null : !this$tokenSecret.equals(other$tokenSecret)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$verificationUrl = this.getVerificationUrl();
        String other$verificationUrl = other.getVerificationUrl();
        if (this$verificationUrl == null ? other$verificationUrl != null : !this$verificationUrl.equals(other$verificationUrl)) {
            return false;
        }
        String this$passwordResetUrl = this.getPasswordResetUrl();
        String other$passwordResetUrl = other.getPasswordResetUrl();
        if (this$passwordResetUrl == null ? other$passwordResetUrl != null : !this$passwordResetUrl.equals(other$passwordResetUrl)) {
            return false;
        }
        String this$inviteUrl = this.getInviteUrl();
        String other$inviteUrl = other.getInviteUrl();
        if (this$inviteUrl == null ? other$inviteUrl != null : !this$inviteUrl.equals(other$inviteUrl)) {
            return false;
        }
        String this$changeEmailUrl = this.getChangeEmailUrl();
        String other$changeEmailUrl = other.getChangeEmailUrl();
        if (this$changeEmailUrl == null ? other$changeEmailUrl != null : !this$changeEmailUrl.equals(other$changeEmailUrl)) {
            return false;
        }
        String this$changeUsernameUrl = this.getChangeUsernameUrl();
        String other$changeUsernameUrl = other.getChangeUsernameUrl();
        return !(this$changeUsernameUrl == null ? other$changeUsernameUrl != null : !this$changeUsernameUrl.equals(other$changeUsernameUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUserCacheTime();
        result = result * 59 + (this.isVerifyEmail() ? 79 : 97);
        long $passwordResetExpiration = this.getPasswordResetExpiration();
        result = result * 59 + (int)($passwordResetExpiration >>> 32 ^ $passwordResetExpiration);
        long $changeEmailExpiration = this.getChangeEmailExpiration();
        result = result * 59 + (int)($changeEmailExpiration >>> 32 ^ $changeEmailExpiration);
        long $changeUsernameExpiration = this.getChangeUsernameExpiration();
        result = result * 59 + (int)($changeUsernameExpiration >>> 32 ^ $changeUsernameExpiration);
        long $inviteExpiration = this.getInviteExpiration();
        result = result * 59 + (int)($inviteExpiration >>> 32 ^ $inviteExpiration);
        String $roleAdmin = this.getRoleAdmin();
        result = result * 59 + ($roleAdmin == null ? 43 : $roleAdmin.hashCode());
        String $roleUser = this.getRoleUser();
        result = result * 59 + ($roleUser == null ? 43 : $roleUser.hashCode());
        String $tokenSecret = this.getTokenSecret();
        result = result * 59 + ($tokenSecret == null ? 43 : $tokenSecret.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $verificationUrl = this.getVerificationUrl();
        result = result * 59 + ($verificationUrl == null ? 43 : $verificationUrl.hashCode());
        String $passwordResetUrl = this.getPasswordResetUrl();
        result = result * 59 + ($passwordResetUrl == null ? 43 : $passwordResetUrl.hashCode());
        String $inviteUrl = this.getInviteUrl();
        result = result * 59 + ($inviteUrl == null ? 43 : $inviteUrl.hashCode());
        String $changeEmailUrl = this.getChangeEmailUrl();
        result = result * 59 + ($changeEmailUrl == null ? 43 : $changeEmailUrl.hashCode());
        String $changeUsernameUrl = this.getChangeUsernameUrl();
        result = result * 59 + ($changeUsernameUrl == null ? 43 : $changeUsernameUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthProperties(roleAdmin=" + this.getRoleAdmin() + ", roleUser=" + this.getRoleUser() + ", tokenSecret=" + this.getTokenSecret() + ", userCacheTime=" + this.getUserCacheTime() + ", baseUrl=" + this.getBaseUrl() + ", prefix=" + this.getPrefix() + ", verifyEmail=" + this.isVerifyEmail() + ", verificationUrl=" + this.getVerificationUrl() + ", passwordResetUrl=" + this.getPasswordResetUrl() + ", inviteUrl=" + this.getInviteUrl() + ", changeEmailUrl=" + this.getChangeEmailUrl() + ", changeUsernameUrl=" + this.getChangeUsernameUrl() + ", passwordResetExpiration=" + this.getPasswordResetExpiration() + ", changeEmailExpiration=" + this.getChangeEmailExpiration() + ", changeUsernameExpiration=" + this.getChangeUsernameExpiration() + ", inviteExpiration=" + this.getInviteExpiration() + ")";
    }
}

