/*
 * Decompiled with CFR 0.152.
 */
package io.rocketbase.commons.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public final class RolesAuthoritiesConverter {
    public static Collection<? extends GrantedAuthority> convert(List<String> roles) {
        return roles != null ? (Collection)roles.stream().map(r -> new SimpleGrantedAuthority(String.format("ROLE_%s", r.replaceAll("^ROLE_", "")))).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static List<String> convert(Collection<? extends GrantedAuthority> authorities) {
        return authorities != null ? authorities.stream().filter(r -> r.getAuthority() != null).map(r -> r.getAuthority().replaceAll("^ROLE_", "")).collect(Collectors.toList()) : Collections.emptyList();
    }
}

